/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupTable;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class LookupOp
implements BufferedImageOp,
RasterOp {
    private LookupTable lut;
    private RenderingHints hints;

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int[] nArray;
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            throw new IllegalArgumentException("LookupOp.filter: IndexColorModel not allowed");
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        BufferedImage bufferedImage3 = bufferedImage2.getColorModel().equals(bufferedImage.getColorModel()) ? bufferedImage2 : this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage3.getRaster();
        if (bufferedImage.getColorModel().hasAlpha() && (this.lut.getNumComponents() == 1 || this.lut.getNumComponents() == bufferedImage.getColorModel().getNumColorComponents())) {
            nArray = new int[bufferedImage.getColorModel().getNumComponents()];
            n = bufferedImage.getColorModel().getNumColorComponents();
            int[] nArray2 = new int[n];
            int n2 = bufferedImage.getMinY();
            while (n2 < bufferedImage.getHeight() + bufferedImage.getMinY()) {
                int n3 = bufferedImage.getMinX();
                while (n3 < bufferedImage.getWidth() + bufferedImage.getMinX()) {
                    writableRaster.getPixel(n3, n2, nArray);
                    System.arraycopy(nArray, 0, nArray2, 0, n);
                    writableRaster2.setPixel(n3, n2, this.lut.lookupPixel(nArray2, nArray));
                    ++n3;
                }
                ++n2;
            }
        } else if (this.lut.getNumComponents() != 1 && this.lut.getNumComponents() != bufferedImage.getColorModel().getNumComponents()) {
            throw new IllegalArgumentException("LookupOp.filter: Incompatible lookup table and source image");
        }
        nArray = new int[bufferedImage.getColorModel().getNumComponents()];
        n = bufferedImage.getMinY();
        while (n < bufferedImage.getHeight() + bufferedImage.getMinY()) {
            int n4 = bufferedImage.getMinX();
            while (n4 < bufferedImage.getWidth() + bufferedImage.getMinX()) {
                writableRaster2.setPixel(n4, n, this.lut.lookupPixel(writableRaster.getPixel(n4, n, nArray), nArray));
                ++n4;
            }
            ++n;
        }
        if (bufferedImage3 != bufferedImage2) {
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHints(this.hints);
            graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(), bufferedImage.isPremultiplied, null);
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public final LookupTable getTable() {
        return this.lut;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (raster.getNumBands() != writableRaster.getNumBands()) {
            throw new IllegalArgumentException();
        }
        if (this.lut.getNumComponents() != 1 && this.lut.getNumComponents() != raster.getNumBands()) {
            throw new IllegalArgumentException();
        }
        int[] nArray = new int[raster.getNumBands()];
        int n = raster.getMinY();
        while (n < raster.getHeight() + raster.getMinY()) {
            int n2 = raster.getMinX();
            while (n2 < raster.getWidth() + raster.getMinX()) {
                writableRaster.setPixel(n2, n, this.lut.lookupPixel(raster.getPixel(n2, n, nArray), nArray));
                ++n2;
            }
            ++n;
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public LookupOp(LookupTable lookupTable, RenderingHints renderingHints) {
        this.lut = lookupTable;
        this.hints = renderingHints;
    }
}

