/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;
import java.awt.ImageCapabilities;

public class BufferCapabilities
implements Cloneable {
    private final ImageCapabilities front;
    private final ImageCapabilities back;
    private final FlipContents flip;

    public ImageCapabilities getFrontBufferCapabilities() {
        return this.front;
    }

    public ImageCapabilities getBackBufferCapabilities() {
        return this.back;
    }

    public boolean isPageFlipping() {
        boolean bl = false;
        if (this.flip != null) {
            bl = true;
        }
        return bl;
    }

    public FlipContents getFlipContents() {
        return this.flip;
    }

    public boolean isFullScreenRequired() {
        return true;
    }

    public boolean isMultiBufferAvailable() {
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    public BufferCapabilities(ImageCapabilities imageCapabilities, ImageCapabilities imageCapabilities2, FlipContents flipContents) {
        if (imageCapabilities == null || imageCapabilities2 == null) {
            throw new IllegalArgumentException();
        }
        this.front = imageCapabilities;
        this.back = imageCapabilities2;
        this.flip = flipContents;
    }

    public static final class FlipContents
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"undefined", "background", "prior", "copied"};
        public static final FlipContents UNDEFINED = new FlipContents(0);
        public static final FlipContents BACKGROUND = new FlipContents(1);
        public static final FlipContents PRIOR = new FlipContents(2);
        public static final FlipContents COPIED = new FlipContents(3);

        private FlipContents(int n) {
            super(n, NAMES);
        }
    }
}

