/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.hash;

import gnu.java.security.hash.BaseHash;
import gnu.java.security.hash.Haval;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.hash.MD2;
import gnu.java.security.hash.MD4;
import gnu.java.security.hash.MD5;
import gnu.java.security.hash.RipeMD128;
import gnu.java.security.hash.RipeMD160;
import gnu.java.security.hash.Sha160;
import gnu.java.security.hash.Sha256;
import gnu.java.security.hash.Sha384;
import gnu.java.security.hash.Sha512;
import gnu.java.security.hash.Tiger;
import gnu.java.security.hash.Whirlpool;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HashFactory {
    public static IMessageDigest getInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        BaseHash baseHash = null;
        if (string.equalsIgnoreCase("whirlpool")) {
            baseHash = new Whirlpool();
        } else if (string.equalsIgnoreCase("ripemd128") || string.equalsIgnoreCase("ripemd-128")) {
            baseHash = new RipeMD128();
        } else if (string.equalsIgnoreCase("ripemd160") || string.equalsIgnoreCase("ripemd-160")) {
            baseHash = new RipeMD160();
        } else if (string.equalsIgnoreCase("sha-160") || string.equalsIgnoreCase("sha-1") || string.equalsIgnoreCase("sha1") || string.equalsIgnoreCase("sha")) {
            baseHash = new Sha160();
        } else if (string.equalsIgnoreCase("sha-256")) {
            baseHash = new Sha256();
        } else if (string.equalsIgnoreCase("sha-384")) {
            baseHash = new Sha384();
        } else if (string.equalsIgnoreCase("sha-512")) {
            baseHash = new Sha512();
        } else if (string.equalsIgnoreCase("tiger")) {
            baseHash = new Tiger();
        } else if (string.equalsIgnoreCase("haval")) {
            baseHash = new Haval();
        } else if (string.equalsIgnoreCase("md5")) {
            baseHash = new MD5();
        } else if (string.equalsIgnoreCase("md4")) {
            baseHash = new MD4();
        } else if (string.equalsIgnoreCase("md2")) {
            baseHash = new MD2();
        } else if (string.equalsIgnoreCase("haval")) {
            baseHash = new Haval();
        }
        if (baseHash != null && !baseHash.selfTest()) {
            throw new InternalError(baseHash.name());
        }
        return baseHash;
    }

    public static final Set getNames() {
        HashSet hashSet = new HashSet();
        hashSet.add("whirlpool");
        hashSet.add("ripemd128");
        hashSet.add("ripemd160");
        hashSet.add("sha-160");
        hashSet.add("sha-256");
        hashSet.add("sha-384");
        hashSet.add("sha-512");
        hashSet.add("tiger");
        hashSet.add("haval");
        hashSet.add("md5");
        hashSet.add("md4");
        hashSet.add("md2");
        return Collections.unmodifiableSet(hashSet);
    }

    private HashFactory() {
    }
}

