/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class NoVarsDynamicScope
extends DynamicScope {
    public NoVarsDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public NoVarsDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        assert (this.staticScope.getNumberOfVariables() == 0) : "NoVarsDynamicScope cannot be grown; use ManyVarsDynamicScope";
    }

    public DynamicScope cloneScope() {
        return new NoVarsDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return IRubyObject.NULL_ARRAY;
    }

    public IRubyObject getValue(int offset, int depth) {
        return this.parent.getValue(offset, depth - 1);
    }

    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        return this.parent.getValueOrNil(offset, depth - 1, nil);
    }

    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with any variables");
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with one or more variables");
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with two or more variables");
    }

    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with three or more variables");
    }

    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with four or more variables");
    }

    public IRubyObject setValue(int offset, IRubyObject value, int depth) {
        return this.parent.setValue(offset, value, depth - 1);
    }

    public IRubyObject setValueDepthZero(IRubyObject value, int offset) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with any variables");
    }

    public IRubyObject setValueZeroDepthZero(IRubyObject value) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with one or more variables");
    }

    public IRubyObject setValueOneDepthZero(IRubyObject value) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with two or more variables");
    }

    public IRubyObject setValueTwoDepthZero(IRubyObject value) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with three or more variables");
    }

    public IRubyObject setValueThreeDepthZero(IRubyObject value) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with four or more variables");
    }

    public void setArgValues(IRubyObject[] values, int size) {
        assert (size == 0) : "NoVarsDynamicScope only supports scopes with no variables";
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs == 0) : "NoVarsDynamicScope only supports scopes with no variables";
        return IRubyObject.NULL_ARRAY;
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " []");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

