/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DumpingInvocationMethodFactory;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.internal.runtime.methods.ReflectionMethodFactory;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodFactory {
    public static final Class[] COMPILED_METHOD_PARAMS = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
    private static boolean reflection = false;
    private static boolean dumping = false;
    private static String dumpingPath = null;

    public static MethodFactory createFactory(ClassLoader classLoader) {
        if (reflection) {
            return new ReflectionMethodFactory();
        }
        if (dumping) {
            return new DumpingInvocationMethodFactory(dumpingPath, classLoader);
        }
        return new InvocationMethodFactory(classLoader);
    }

    public abstract DynamicMethod getCompiledMethod(RubyModule var1, String var2, Arity var3, Visibility var4, StaticScope var5, Object var6, CallConfiguration var7);

    public abstract DynamicMethod getCompiledMethodLazily(RubyModule var1, String var2, Arity var3, Visibility var4, StaticScope var5, Object var6, CallConfiguration var7);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, List<JavaMethodDescriptor> var2);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, JavaMethodDescriptor var2);

    public abstract void defineIndexedAnnotatedMethods(RubyModule var1, Class var2, MethodDefiningCallback var3);

    static {
        if (Ruby.isSecurityRestricted()) {
            reflection = true;
        } else {
            if (SafePropertyAccessor.getProperty("jruby.reflection") != null && SafePropertyAccessor.getBoolean("jruby.reflection")) {
                reflection = true;
            }
            if (SafePropertyAccessor.getProperty("jruby.dump_invocations") != null) {
                dumping = true;
                dumpingPath = SafePropertyAccessor.getProperty("jruby.dump_invocations");
            }
        }
    }

    public static interface MethodDefiningCallback {
        public void define(RubyModule var1, JavaMethodDescriptor var2, DynamicMethod var3);
    }
}

