/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SplatNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAsgnNode
extends AssignableNode {
    private final ListNode headNode;
    private final Node argsNode;

    public MultipleAsgnNode(ISourcePosition position, ListNode headNode, Node argsNode) {
        super(position, NodeType.MULTIPLEASGNNODE);
        this.headNode = headNode;
        this.argsNode = argsNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public ListNode getHeadNode() {
        return this.headNode;
    }

    @Override
    public Arity getArity() {
        if (this.argsNode != null) {
            return Arity.required(this.headNode == null ? 0 : this.headNode.size());
        }
        return Arity.fixed(this.headNode.size());
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.headNode, this.argsNode, this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        switch (this.getValueNode().nodeId) {
            case ARRAYNODE: {
                ArrayNode iVisited2 = (ArrayNode)this.getValueNode();
                return ASTInterpreter.multipleAsgnArrayNode(runtime, context, this, iVisited2, self, aBlock);
            }
            case SPLATNODE: {
                SplatNode splatNode = (SplatNode)this.getValueNode();
                RubyArray rubyArray = RuntimeHelpers.splatValue(splatNode.getValue().interpret(runtime, context, self, aBlock));
                return AssignmentVisitor.multiAssign(runtime, context, self, this, rubyArray, false);
            }
        }
        IRubyObject value = this.getValueNode().interpret(runtime, context, self, aBlock);
        if (!(value instanceof RubyArray)) {
            value = RubyArray.newArray(runtime, value);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, this, (RubyArray)value, false);
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        if (!(value instanceof RubyArray)) {
            value = ArgsUtil.convertToRubyArray(runtime, value, this.headNode != null);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, this, (RubyArray)value, checkArity);
    }
}

