/*
 * Decompiled with CFR 0.152.
 */
package org.joni.encoding.specific;

import org.joni.IntHolder;
import org.joni.encoding.specific.ASCIIEncoding;
import org.joni.encoding.unicode.UnicodeEncoding;
import org.joni.exception.ValueException;

public final class UTF8Encoding
extends UnicodeEncoding {
    static final boolean USE_INVALID_CODE_SCHEME = true;
    private static final int INVALID_CODE_FE = -2;
    private static final int INVALID_CODE_FF = -1;
    static final int[] UTF8EncLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 1, 1};
    public static final UTF8Encoding INSTANCE = new UTF8Encoding();

    protected UTF8Encoding() {
        super(UTF8EncLen);
    }

    public String toString() {
        return "UTF-8";
    }

    public int maxLength() {
        return 6;
    }

    public int minLength() {
        return 1;
    }

    public boolean isFixedWidth() {
        return false;
    }

    public boolean isNewLine(byte[] bytes, int p, int end) {
        return p < end && bytes[p] == 10;
    }

    public int codeToMbcLength(int code) {
        if ((code & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((code & 0xFFFFF800) == 0) {
            return 2;
        }
        if ((code & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((code & 0xFFE00000) == 0) {
            return 4;
        }
        if ((code & 0xFC000000) == 0) {
            return 5;
        }
        if ((code & Integer.MIN_VALUE) == 0) {
            return 6;
        }
        if (code == -2) {
            return 1;
        }
        if (code == -1) {
            return 1;
        }
        throw new ValueException("invalid code point value");
    }

    public int mbcToCode(byte[] bytes, int p, int end) {
        int len = this.length(bytes[p]);
        int c = bytes[p++] & 0xFF;
        if (len > 1) {
            int n = c & (1 << 6 - --len) - 1;
            while (len-- != 0) {
                c = bytes[p++] & 0xFF;
                n = n << 6 | c & 0x3F;
            }
            return n;
        }
        if (c > 253) {
            return c == 254 ? -2 : -1;
        }
        return c;
    }

    static byte trailS(int code, int shift) {
        return (byte)(code >>> shift & 0x3F | 0x80);
    }

    static byte trail0(int code) {
        return (byte)(code & 0x3F | 0x80);
    }

    public int codeToMbc(int code, byte[] bytes, int p) {
        int p_ = p;
        if ((code & 0xFFFFFF80) == 0) {
            bytes[p_] = (byte)code;
            return 1;
        }
        if ((code & 0xFFFFF800) == 0) {
            bytes[p_++] = (byte)(code >>> 6 & 0x1F | 0xC0);
        } else if ((code & 0xFFFF0000) == 0) {
            bytes[p_++] = (byte)(code >>> 12 & 0xF | 0xE0);
            bytes[p_++] = UTF8Encoding.trailS(code, 6);
        } else if ((code & 0xFFE00000) == 0) {
            bytes[p_++] = (byte)(code >>> 18 & 7 | 0xF0);
            bytes[p_++] = UTF8Encoding.trailS(code, 12);
            bytes[p_++] = UTF8Encoding.trailS(code, 6);
        } else if ((code & 0xFC000000) == 0) {
            bytes[p_++] = (byte)(code >>> 24 & 3 | 0xF8);
            bytes[p_++] = UTF8Encoding.trailS(code, 18);
            bytes[p_++] = UTF8Encoding.trailS(code, 12);
            bytes[p_++] = UTF8Encoding.trailS(code, 6);
        } else if ((code & Integer.MIN_VALUE) == 0) {
            bytes[p_++] = (byte)(code >>> 30 & 1 | 0xFC);
            bytes[p_++] = UTF8Encoding.trailS(code, 24);
            bytes[p_++] = UTF8Encoding.trailS(code, 18);
            bytes[p_++] = UTF8Encoding.trailS(code, 12);
            bytes[p_++] = UTF8Encoding.trailS(code, 6);
        } else {
            if (code == -2) {
                bytes[p_] = -2;
                return 1;
            }
            if (code == -1) {
                bytes[p_] = -1;
                return 1;
            }
            throw new ValueException("too big wide-char value");
        }
        bytes[p_++] = UTF8Encoding.trail0(code);
        return p_ - p;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] fold) {
        int p = pp.value++;
        int foldP = 0;
        if (UTF8Encoding.isMbcAscii(bytes[p])) {
            fold[foldP] = ASCIIEncoding.AsciiToLowerCaseTable[bytes[p] & 0xFF];
            return 1;
        }
        return super.mbcCaseFold(flag, bytes, pp, end, fold);
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 128;
        return super.ctypeCodeRange(ctype);
    }

    private static boolean utf8IsLead(int c) {
        return (c & 0xC0 & 0xFF) != 128;
    }

    public int leftAdjustCharHead(byte[] bytes, int p, int end) {
        int p_;
        if (end <= p) {
            return end;
        }
        for (p_ = end; !UTF8Encoding.utf8IsLead(bytes[p_] & 0xFF) && p_ > p; --p_) {
        }
        return p_;
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p, int end) {
        return true;
    }
}

