/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.ant.PackageMapping;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.filters.LineContainsRegExp;
import org.apache.tools.ant.filters.TokenFilter;
import org.apache.tools.ant.taskdefs.Concat;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.RegularExpression;

public class IvyExtractFromSources
extends IvyTask {
    private String _organisation;
    private String _module;
    private String _revision;
    private String _status;
    private List _ignoredPackaged = new ArrayList();
    private Map _mapping = new HashMap();
    private Concat _concat = new Concat();
    private File _to;

    public void addConfiguredIgnore(Ignore ignore) {
        this._ignoredPackaged.add(ignore.getPackage());
    }

    public File getTo() {
        return this._to;
    }

    public void setTo(File to) {
        this._to = to;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public String getStatus() {
        return this._status;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public void addConfiguredMapping(PackageMapping mapping) {
        this._mapping.put(mapping.getPackage(), mapping.getModuleRevisionId());
    }

    public void addFileSet(FileSet fileSet) {
        this._concat.addFileset(fileSet);
    }

    public void execute() throws BuildException {
        ModuleRevisionId mrid;
        this.configureConcat();
        StringWriter out = new StringWriter();
        this._concat.setWriter((Writer)out);
        this._concat.execute();
        HashSet<String> importsSet = new HashSet<String>(Arrays.asList(((Object)out).toString().split("\n")));
        HashSet<ModuleRevisionId> dependencies = new HashSet<ModuleRevisionId>();
        Iterator iter = importsSet.iterator();
        while (iter.hasNext()) {
            String pack = ((String)iter.next()).trim();
            mrid = this.getMapping(pack);
            if (mrid == null) continue;
            dependencies.add(mrid);
        }
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(this._to));
            writer.println("<ivy-module version=\"1.0\">");
            writer.println("\t<info organisation=\"" + this._organisation + "\"");
            writer.println("\t       module=\"" + this._module + "\"");
            if (this._revision != null) {
                writer.println("\t       revision=\"" + this._revision + "\"");
            }
            if (this._status != null) {
                writer.println("\t       status=\"" + this._status + "\"");
            } else {
                writer.println("\t       status=\"integration\"");
            }
            writer.println("\t/>");
            if (!dependencies.isEmpty()) {
                writer.println("\t<dependencies>");
                Iterator iter2 = dependencies.iterator();
                while (iter2.hasNext()) {
                    mrid = (ModuleRevisionId)iter2.next();
                    writer.println("\t\t<dependency org=\"" + mrid.getOrganisation() + "\" name=\"" + mrid.getName() + "\" rev=\"" + mrid.getRevision() + "\"/>");
                }
                writer.println("\t</dependencies>");
            }
            writer.println("</ivy-module>");
            writer.close();
            this.log(dependencies.size() + " dependencies put in " + this._to);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("impossible to create file " + this._to + ": " + e, (Throwable)e);
        }
    }

    private ModuleRevisionId getMapping(String pack) {
        String askedPack = pack;
        ModuleRevisionId ret = null;
        while (ret == null && pack.length() > 0) {
            if (this._ignoredPackaged.contains(pack)) {
                return null;
            }
            ret = (ModuleRevisionId)this._mapping.get(pack);
            int lastDotIndex = pack.lastIndexOf(46);
            if (lastDotIndex == -1) break;
            pack = pack.substring(0, lastDotIndex);
        }
        if (ret == null) {
            this.log("no mapping found for " + askedPack, 3);
        }
        return ret;
    }

    private void configureConcat() {
        this._concat.setProject(this.getProject());
        this._concat.setTaskName(this.getTaskName());
        FilterChain filterChain = new FilterChain();
        LineContainsRegExp lcre = new LineContainsRegExp();
        RegularExpression regexp = new RegularExpression();
        regexp.setPattern("^import .+;");
        lcre.addConfiguredRegexp(regexp);
        filterChain.add((ChainableReader)lcre);
        TokenFilter tf = new TokenFilter();
        TokenFilter.ReplaceRegex rre = new TokenFilter.ReplaceRegex();
        rre.setPattern("import (.+);.*");
        rre.setReplace("\\1");
        tf.add((TokenFilter.Filter)rre);
        filterChain.add((ChainableReader)tf);
        this._concat.addFilterChain(filterChain);
    }

    public static class Ignore {
        String _package;

        public String getPackage() {
            return this._package;
        }

        public void setPackage(String package1) {
            this._package = package1;
        }
    }
}

