<?php
/**
 * Autoloader definition for eZ Publish kernel files.
 *
 * @copyright Copyright (C) 2005-2007 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/gnu_gpl GNU GPL v2
 * @version //autogentag//
 * @package kernel
 *
 */

return array(
      'Cezpdf'                             => 'lib/ezpdf/classes/class.ezpdf.php',
      'Cpdf'                               => 'lib/ezpdf/classes/class.pdf.php',
      'eZ1337Translator'                   => 'lib/ezi18n/classes/ez1337translator.php',
      'eZAlphabetOperator'                 => 'kernel/common/ezalphabetoperator.php',
      'eZApproveCollaborationHandler'      => 'kernel/classes/collaborationhandlers/ezapprove/ezapprovecollaborationhandler.php',
      'eZApproveType'                      => 'kernel/classes/workflowtypes/event/ezapprove/ezapprovetype.php',
      'eZArchiveHandler'                   => 'lib/ezfile/classes/ezarchivehandler.php',
      'eZAudit'                            => 'kernel/classes/ezaudit.php',
      'eZAuthor'                           => 'kernel/classes/datatypes/ezauthor/ezauthor.php',
      'eZAuthorType'                       => 'kernel/classes/datatypes/ezauthor/ezauthortype.php',
      'eZAutoLinkOperator'                 => 'kernel/common/ezautolinkoperator.php',
      'eZAutoloadGenerator'                => 'lib/ezutils/classes/ezautoloadgenerator.php',
      'eZBCMath'                           => 'lib/ezmath/classes/mathhandlers/ezbcmath.php',
      'eZBZIP2Handler'                     => 'lib/ezfile/classes/ezbzip2compressionhandler.php',
      'eZBasket'                           => 'kernel/classes/ezbasket.php',
      'eZBinaryFile'                       => 'kernel/classes/datatypes/ezbinaryfile/ezbinaryfile.php',
      'eZBinaryFileHandler'                => 'kernel/classes/ezbinaryfilehandler.php',
      'eZBinaryFileType'                   => 'kernel/classes/datatypes/ezbinaryfile/ezbinaryfiletype.php',
      'eZBooleanType'                      => 'kernel/classes/datatypes/ezboolean/ezbooleantype.php',
      'eZBorkTranslator'                   => 'lib/ezi18n/classes/ezborktranslator.php',
      'eZCLI'                              => 'lib/ezutils/classes/ezcli.php',
      'eZCache'                            => 'kernel/classes/ezcache.php',
      'eZCharTransform'                    => 'lib/ezi18n/classes/ezchartransform.php',
      'eZCharsetInfo'                      => 'lib/ezi18n/classes/ezcharsetinfo.php',
      'eZClassFunctionCollection'          => 'kernel/class/ezclassfunctioncollection.php',
      'eZClassFunctions'                   => 'kernel/class/ezclassfunctions.php',
      'eZClusterFileFailure'               => 'kernel/classes/ezclusterfilefailure.php',
      'eZClusterFileHandler'               => 'kernel/classes/ezclusterfilehandler.php',
      'eZCodeMapper'                       => 'lib/ezi18n/classes/ezcodemapper.php',
      'eZCodePage'                         => 'lib/ezi18n/classes/ezcodepage.php',
      'eZCodePageCodec'                    => 'lib/ezi18n/classes/ezcodepagecodec.php',
      'eZCodePageMapper'                   => 'lib/ezi18n/classes/ezcodepagemapper.php',
      'eZCodeTemplate'                     => 'kernel/classes/ezcodetemplate.php',
      'eZCollaborationEventType'           => 'kernel/classes/notification/event/ezcollaboration/ezcollaborationtype.php',
      'eZCollaborationFunctionCollection'  => 'kernel/collaboration/ezcollaborationfunctioncollection.php',
      'eZCollaborationGroup'               => 'kernel/classes/ezcollaborationgroup.php',
      'eZCollaborationItem'                => 'kernel/classes/ezcollaborationitem.php',
      'eZCollaborationItemGroupLink'       => 'kernel/classes/ezcollaborationitemgrouplink.php',
      'eZCollaborationItemHandler'         => 'kernel/classes/ezcollaborationitemhandler.php',
      'eZCollaborationItemMessageLink'     => 'kernel/classes/ezcollaborationitemmessagelink.php',
      'eZCollaborationItemParticipantLink' => 'kernel/classes/ezcollaborationitemparticipantlink.php',
      'eZCollaborationItemStatus'          => 'kernel/classes/ezcollaborationitemstatus.php',
      'eZCollaborationNotificationHandler' => 'kernel/classes/notification/handler/ezcollaborationnotification/ezcollaborationnotificationhandler.php',
      'eZCollaborationNotificationRule'    => 'kernel/classes/notification/handler/ezcollaborationnotification/ezcollaborationnotificationrule.php',
      'eZCollaborationProfile'             => 'kernel/classes/ezcollaborationprofile.php',
      'eZCollaborationSimpleMessage'       => 'kernel/classes/ezcollaborationsimplemessage.php',
      'eZCollaborationViewHandler'         => 'kernel/classes/ezcollaborationviewhandler.php',
      'eZComplexType'                      => 'lib/ezxml/classes/ezcomplextype.php',
      'eZCompressionHandler'               => 'lib/ezfile/classes/ezcompressionhandler.php',
      'eZConfirmOrderHandler'              => 'kernel/classes/ezconfirmorderhandler.php',
      'eZContentBrowse'                    => 'kernel/classes/ezcontentbrowse.php',
      'eZContentBrowseBookmark'            => 'kernel/classes/ezcontentbrowsebookmark.php',
      'eZContentBrowseRecent'              => 'kernel/classes/ezcontentbrowserecent.php',
      'eZContentCache'                     => 'kernel/classes/ezcontentcache.php',
      'eZContentCacheManager'              => 'kernel/classes/ezcontentcachemanager.php',
      'eZContentClass'                     => 'kernel/classes/ezcontentclass.php',
      'eZContentClassAttribute'            => 'kernel/classes/ezcontentclassattribute.php',
      'eZContentClassAttributeNameList'    => 'kernel/classes/ezcontentclassattributenamelist.php',
      'eZContentClassClassGroup'           => 'kernel/classes/ezcontentclassclassgroup.php',
      'eZContentClassGroup'                => 'kernel/classes/ezcontentclassgroup.php',
      'eZContentClassName'                 => 'kernel/classes/ezcontentclassname.php',
      'eZContentClassNameList'             => 'kernel/classes/ezcontentclassnamelist.php',
      'eZContentClassOperations'           => 'kernel/classes/ezcontentclassoperations.php',
      'eZContentClassPackageCreator'       => 'kernel/classes/packagecreators/ezcontentclass/ezcontentclasspackagecreator.php',
      'eZContentClassPackageHandler'       => 'kernel/classes/packagehandlers/ezcontentclass/ezcontentclasspackagehandler.php',
      'eZContentFunctionCollection'        => 'kernel/content/ezcontentfunctioncollection.php',
      'eZContentFunctions'                 => 'kernel/classes/ezcontentfunctions.php',
      'eZContentLanguage'                  => 'kernel/classes/ezcontentlanguage.php',
      'eZContentObject'                    => 'kernel/classes/ezcontentobject.php',
      'eZContentObjectAssignmentHandler'   => 'kernel/classes/ezcontentobjectassignmenthandler.php',
      'eZContentObjectAttribute'           => 'kernel/classes/ezcontentobjectattribute.php',
      'eZContentObjectEditHandler'         => 'kernel/classes/ezcontentobjectedithandler.php',
      'eZContentObjectOperations'          => 'kernel/classes/ezcontentobjectoperations.php',
      'eZContentObjectPackageCreator'      => 'kernel/classes/packagecreators/ezcontentobject/ezcontentobjectpackagecreator.php',
      'eZContentObjectPackageHandler'      => 'kernel/classes/packagehandlers/ezcontentobject/ezcontentobjectpackagehandler.php',
      'eZContentObjectPackageInstaller'    => 'kernel/classes/packageinstallers/ezcontentobject/ezcontentobjectpackageinstaller.php',
      'eZContentObjectTranslation'         => 'kernel/classes/ezcontentobjecttranslation.php',
      'eZContentObjectTrashNode'           => 'kernel/classes/ezcontentobjecttrashnode.php',
      'eZContentObjectTreeNode'            => 'kernel/classes/ezcontentobjecttreenode.php',
      'eZContentObjectTreeNodeOperations'  => 'kernel/classes/ezcontentobjecttreenodeoperations.php',
      'eZContentObjectVersion'             => 'kernel/classes/ezcontentobjectversion.php',
      'eZContentOperationCollection'       => 'kernel/content/ezcontentoperationcollection.php',
      'eZContentStructureTreeOperator'     => 'kernel/common/ezcontentstructuretreeoperator.php',
      'eZContentUpload'                    => 'kernel/classes/ezcontentupload.php',
      'eZContentUploadHandler'             => 'kernel/classes/ezcontentuploadhandler.php',
      'eZCountryType'                      => 'kernel/classes/datatypes/ezcountry/ezcountrytype.php',
      'eZCurrency'                         => 'lib/ezlocale/classes/ezcurrency.php',
      'eZCurrencyConverter'                => 'kernel/shop/classes/ezcurrencyconverter.php',
      'eZCurrencyData'                     => 'kernel/shop/classes/ezcurrencydata.php',
      'eZCurrentTimeType'                  => 'kernel/classes/notification/event/ezcurrenttime/ezcurrenttimetype.php',
      'eZDB'                               => 'lib/ezdb/classes/ezdb.php',
      'eZDBFileHandler'                    => 'kernel/classes/clusterfilehandlers/ezdbfilehandler.php',
      'eZDBFileHandlerMysqlBackend'        => 'kernel/classes/clusterfilehandlers/dbbackends/mysql.php',
      'eZDBGarbageCollector'               => 'kernel/classes/ezdbgarbagecollector.php',
      'eZDBInterface'                      => 'lib/ezdb/classes/ezdbinterface.php',
      'eZDBPackageHandler'                 => 'kernel/classes/packagehandlers/ezdb/ezdbpackagehandler.php',
      'eZDBSchemaInterface'                => 'lib/ezdbschema/classes/ezdbschemainterface.php',
      'eZDBTool'                           => 'lib/ezdb/classes/ezdbtool.php',
      'eZDOMDocument'                      => 'lib/ezxml/classes/ezdomdocument.php',
      'eZDOMNode'                          => 'lib/ezxml/classes/ezdomnode.php',
      'eZDataType'                         => 'kernel/classes/ezdatatype.php',
      'eZDate'                             => 'lib/ezlocale/classes/ezdate.php',
      'eZDateOperatorCollection'           => 'kernel/common/ezdateoperatorcollection.php',
      'eZDateTime'                         => 'lib/ezlocale/classes/ezdatetime.php',
      'eZDateTimeType'                     => 'kernel/classes/datatypes/ezdatetime/ezdatetimetype.php',
      'eZDateTimeValidator'                => 'lib/ezutils/classes/ezdatetimevalidator.php',
      'eZDateType'                         => 'kernel/classes/datatypes/ezdate/ezdatetype.php',
      'eZDateUtils'                        => 'lib/ezlocale/classes/ezdateutils.php',
      'eZDbSchema'                         => 'lib/ezdbschema/classes/ezdbschema.php',
      'eZDbSchemaChecker'                  => 'lib/ezdbschema/classes/ezdbschemachecker.php',
      'eZDebug'                            => 'lib/ezutils/classes/ezdebug.php',
      'eZDebugSetting'                     => 'lib/ezutils/classes/ezdebugsetting.php',
      'eZDefaultBasketInfoHandler'         => 'kernel/classes/basketinfohandlers/ezdefaultbasketinfohandler.php',
      'eZDefaultConfirmOrderHandler'       => 'kernel/classes/confirmorderhandlers/ezdefaultconfirmorderhandler.php',
      'eZDefaultShopAccountHandler'        => 'kernel/classes/shopaccounthandlers/ezdefaultshopaccounthandler.php',
      'eZDefaultVATHandler'                => 'kernel/classes/vathandlers/ezdefaultvathandler.php',
      'eZDiff'                             => 'lib/ezdiff/classes/ezdiff.php',
      'eZDiffContainerObject'              => 'lib/ezdiff/classes/ezdiffcontainerobject.php',
      'eZDiffContainerObjectEngine'        => 'lib/ezdiff/classes/ezdiffcontainerobjectengine.php',
      'eZDiffContent'                      => 'lib/ezdiff/classes/ezdiffcontent.php',
      'eZDiffEngine'                       => 'lib/ezdiff/classes/ezdiffengine.php',
      'eZDiffMatrix'                       => 'lib/ezdiff/classes/ezdiffmatrix.php',
      'eZDiffTextEngine'                   => 'lib/ezdiff/classes/ezdifftextengine.php',
      'eZDiffXMLTextEngine'                => 'lib/ezdiff/classes/ezdiffxmltextengine.php',
      'eZDir'                              => 'lib/ezfile/classes/ezdir.php',
      'eZDiscount'                         => 'kernel/classes/ezdiscount.php',
      'eZDiscountRule'                     => 'kernel/classes/ezdiscountrule.php',
      'eZDiscountSubRule'                  => 'kernel/classes/ezdiscountsubrule.php',
      'eZDiscountSubRuleValue'             => 'kernel/classes/ezdiscountsubrulevalue.php',
      'eZECBHandler'                       => 'kernel/shop/classes/exchangeratehandlers/ezecb/ezecbhandler.php',
      'eZEXIFImageAnalyzer'                => 'lib/ezimage/classes/ezexifimageanalyzer.php',
      'eZElementType'                      => 'lib/ezxml/classes/ezelementtype.php',
      'eZEmailType'                        => 'kernel/classes/datatypes/ezemail/ezemailtype.php',
      'eZEnum'                             => 'kernel/classes/datatypes/ezenum/ezenum.php',
      'eZEnumObjectValue'                  => 'kernel/classes/datatypes/ezenum/ezenumobjectvalue.php',
      'eZEnumType'                         => 'kernel/classes/datatypes/ezenum/ezenumtype.php',
      'eZEnumValue'                        => 'kernel/classes/datatypes/ezenum/ezenumvalue.php',
      'eZError'                            => 'kernel/classes/ezerror.php',
      'eZExchangeRatesUpdateHandler'       => 'kernel/shop/classes/exchangeratehandlers/ezexchangeratesupdatehandler.php',
      'eZExecution'                        => 'lib/ezutils/classes/ezexecution.php',
      'eZExpiryHandler'                    => 'lib/ezutils/classes/ezexpiryhandler.php',
      'eZExtension'                        => 'lib/ezutils/classes/ezextension.php',
      'eZExtensionPackageCreator'          => 'kernel/classes/packagecreators/ezextension/ezextensionpackagecreator.php',
      'eZExtensionPackageHandler'          => 'kernel/classes/packagehandlers/ezextension/ezextensionpackagehandler.php',
      'eZFSFileHandler'                    => 'kernel/classes/clusterfilehandlers/ezfsfilehandler.php',
      'eZFile'                             => 'lib/ezfile/classes/ezfile.php',
      'eZFileDirectHandler'                => 'kernel/classes/binaryhandlers/ezfiledirect/ezfiledirecthandler.php',
      'eZFileHandler'                      => 'lib/ezfile/classes/ezfilehandler.php',
      'eZFilePackageHandler'               => 'kernel/classes/packagehandlers/ezfile/ezfilepackagehandler.php',
      'eZFilePassthroughHandler'           => 'kernel/classes/binaryhandlers/ezfilepassthrough/ezfilepassthroughhandler.php',
      'eZFilePasstroughHandler'            => 'kernel/classes/binaryhandlers/ezfilepasstrough/ezfilepasstroughhandler.php',
      'eZFileTransport'                    => 'lib/ezutils/classes/ezfiletransport.php',
      'eZFloatType'                        => 'kernel/classes/datatypes/ezfloat/ezfloattype.php',
      'eZFloatValidator'                   => 'lib/ezutils/classes/ezfloatvalidator.php',
      'eZForgotPassword'                   => 'kernel/classes/datatypes/ezuser/ezforgotpassword.php',
      'eZForwardCompressionHandler'        => 'lib/ezfile/classes/ezforwardcompressionhandler.php',
      'eZFunctionHandler'                  => 'lib/ezutils/classes/ezfunctionhandler.php',
      'eZGIFImageAnalyzer'                 => 'lib/ezimage/classes/ezgifimageanalyzer.php',
      'eZGZIPCompressionHandler'           => 'lib/ezfile/classes/ezgzipcompressionhandler.php',
      'eZGZIPShellCompressionHandler'      => 'lib/ezfile/classes/ezgzipshellcompressionhandler.php',
      'eZGZIPZLIBCompressionHandler'       => 'lib/ezfile/classes/ezgzipzlibcompressionhandler.php',
      'eZGeneralDigestHandler'             => 'kernel/classes/notification/handler/ezgeneraldigest/ezgeneraldigesthandler.php',
      'eZGeneralDigestUserSettings'        => 'kernel/classes/notification/handler/ezgeneraldigest/ezgeneraldigestusersettings.php',
      'eZHTTPFile'                         => 'lib/ezutils/classes/ezhttpfile.php',
      'eZHTTPHeader'                       => 'kernel/classes/ezhttpheader.php',
      'eZHTTPPersistence'                  => 'lib/ezutils/classes/ezhttppersistence.php',
      'eZHTTPTool'                         => 'lib/ezutils/classes/ezhttptool.php',
      'eZINI'                              => 'lib/ezutils/classes/ezini.php',
      'eZINIAddonPackageHandler'           => 'kernel/classes/packagehandlers/eziniaddon/eziniaddonpackagehandler.php',
      'eZISBN10To13Converter'              => 'bin/php/ezconvert2isbn13.php',
      'eZISBN13'                           => 'kernel/classes/datatypes/ezisbn/ezisbn13.php',
      'eZISBNGroup'                        => 'kernel/classes/datatypes/ezisbn/ezisbngroup.php',
      'eZISBNGroupRange'                   => 'kernel/classes/datatypes/ezisbn/ezisbngrouprange.php',
      'eZISBNRegistrantRange'              => 'kernel/classes/datatypes/ezisbn/ezisbnregistrantrange.php',
      'eZISBNType'                         => 'kernel/classes/datatypes/ezisbn/ezisbntype.php',
      'eZIdentifierType'                   => 'kernel/classes/datatypes/ezidentifier/ezidentifiertype.php',
      'eZImage'                            => 'kernel/classes/datatypes/ezimage/ezimage.php',
      'eZImageAliasHandler'                => 'kernel/classes/datatypes/ezimage/ezimagealiashandler.php',
      'eZImageAnalyzer'                    => 'lib/ezimage/classes/ezimageanalyzer.php',
      'eZImageFactory'                     => 'lib/ezimage/classes/ezimagefactory.php',
      'eZImageFile'                        => 'kernel/classes/datatypes/ezimage/ezimagefile.php',
      'eZImageFont'                        => 'lib/ezimage/classes/ezimagefont.php',
      'eZImageGDFactory'                   => 'lib/ezimage/classes/ezimagegdhandler.php',
      'eZImageGDHandler'                   => 'lib/ezimage/classes/ezimagegdhandler.php',
      'eZImageHandler'                     => 'lib/ezimage/classes/ezimagehandler.php',
      'eZImageInterface'                   => 'lib/ezimage/classes/ezimageinterface.php',
      'eZImageLayer'                       => 'lib/ezimage/classes/ezimagelayer.php',
      'eZImageManager'                     => 'lib/ezimage/classes/ezimagemanager.php',
      'eZImageObject'                      => 'lib/ezimage/classes/ezimageobject.php',
      'eZImageShellFactory'                => 'lib/ezimage/classes/ezimageshellhandler.php',
      'eZImageShellHandler'                => 'lib/ezimage/classes/ezimageshellhandler.php',
      'eZImageTextLayer'                   => 'lib/ezimage/classes/ezimagetextlayer.php',
      'eZImageType'                        => 'kernel/classes/datatypes/ezimage/ezimagetype.php',
      'eZImageVariation'                   => 'kernel/classes/datatypes/ezimage/ezimagevariation.php',
      'eZImportLookupTable'                => 'kernel/classes/ezimportlookuptable.php',
      'eZInfocollectorFunctionCollection'  => 'kernel/infocollector/ezinfocollectorfunctioncollection.php',
      'eZInformationCollection'            => 'kernel/classes/ezinformationcollection.php',
      'eZInformationCollectionAttribute'   => 'kernel/classes/ezinformationcollectionattribute.php',
      'eZIniSettingType'                   => 'kernel/classes/datatypes/ezinisetting/ezinisettingtype.php',
      'eZInputValidator'                   => 'lib/ezutils/classes/ezinputvalidator.php',
      'eZInstallScriptPackageHandler'      => 'kernel/classes/packagehandlers/ezinstallscript/ezinstallscriptpackagehandler.php',
      'eZInstallScriptPackageInstaller'    => 'kernel/classes/packageinstallers/ezinstallscript/ezinstallscriptpackageinstaller.php',
      'eZIntegerType'                      => 'kernel/classes/datatypes/ezinteger/ezintegertype.php',
      'eZIntegerValidator'                 => 'lib/ezutils/classes/ezintegervalidator.php',
      'eZKernelOperator'                   => 'kernel/common/ezkerneloperator.php',
      'eZKeyword'                          => 'kernel/classes/datatypes/ezkeyword/ezkeyword.php',
      'eZKeywordType'                      => 'kernel/classes/datatypes/ezkeyword/ezkeywordtype.php',
      'eZLDAPUser'                         => 'kernel/classes/datatypes/ezuser/ezldapuser.php',
      'eZLayoutFunctionCollection'         => 'kernel/layout/ezlayoutfunctioncollection.php',
      'eZLintSchema'                       => 'lib/ezdbschema/classes/ezlintschema.php',
      'eZLocale'                           => 'lib/ezlocale/classes/ezlocale.php',
      'eZLog'                              => 'lib/ezfile/classes/ezlog.php',
      'eZMBStringMapper'                   => 'lib/ezi18n/classes/ezmbstringmapper.php',
      'eZMD5'                              => 'lib/ezfile/classes/ezmd5.php',
      'eZMail'                             => 'lib/ezutils/classes/ezmail.php',
      'eZMailNotificationTransport'        => 'kernel/classes/notification/ezmailnotificationtransport.php',
      'eZMailTransport'                    => 'lib/ezutils/classes/ezmailtransport.php',
      'eZMath'                             => 'lib/ezutils/classes/ezmath.php',
      'eZMatrix'                           => 'kernel/classes/datatypes/ezmatrix/ezmatrix.php',
      'eZMatrixDefinition'                 => 'kernel/classes/datatypes/ezmatrix/ezmatrixdefinition.php',
      'eZMatrixType'                       => 'kernel/classes/datatypes/ezmatrix/ezmatrixtype.php',
      'eZMedia'                            => 'kernel/classes/datatypes/ezmedia/ezmedia.php',
      'eZMediaType'                        => 'kernel/classes/datatypes/ezmedia/ezmediatype.php',
      'eZMimeType'                         => 'lib/ezutils/classes/ezmimetype.php',
      'eZModule'                           => 'lib/ezutils/classes/ezmodule.php',
      'eZModuleFunctionInfo'               => 'lib/ezutils/classes/ezmodulefunctioninfo.php',
      'eZModuleManager'                    => 'kernel/classes/ezmodulemanager.php',
      'eZModuleOperationInfo'              => 'lib/ezutils/classes/ezmoduleoperationinfo.php',
      'eZModuleOperator'                   => 'kernel/common/ezmoduleoperator.php',
      'eZModuleParamsOperator'             => 'kernel/common/ezmoduleparamsoperator.php',
      'eZMultiOption'                      => 'kernel/classes/datatypes/ezmultioption/ezmultioption.php',
      'eZMultiOption2'                     => 'kernel/classes/datatypes/ezmultioption2/ezmultioption2.php',
      'eZMultiOption2Type'                 => 'kernel/classes/datatypes/ezmultioption2/ezmultioption2type.php',
      'eZMultiOptionType'                  => 'kernel/classes/datatypes/ezmultioption/ezmultioptiontype.php',
      'eZMultiPrice'                       => 'kernel/classes/datatypes/ezmultiprice/ezmultiprice.php',
      'eZMultiPriceData'                   => 'kernel/shop/classes/ezmultipricedata.php',
      'eZMultiPriceType'                   => 'kernel/classes/datatypes/ezmultiprice/ezmultipricetype.php',
      'eZMultiplexerType'                  => 'kernel/classes/workflowtypes/event/ezmultiplexer/ezmultiplexertype.php',
      'eZMutex'                            => 'lib/ezutils/classes/ezmutex.php',
      'eZMySQLBackendError'                => 'kernel/classes/clusterfilehandlers/dbbackends/mysqlbackenderror.php',
      'eZMySQLDB'                          => 'lib/ezdb/classes/ezmysqldb.php',
      'eZMySQLiDB'                         => 'lib/ezdb/classes/ezmysqlidb.php',
      'eZMysqlSchema'                      => 'lib/ezdbschema/classes/ezmysqlschema.php',
      'eZNamePatternResolver'              => 'kernel/classes/eznamepatternresolver.php',
      'eZNavigationPart'                   => 'kernel/classes/eznavigationpart.php',
      'eZNoCompressionHandler'             => 'lib/ezfile/classes/eznocompressionhandler.php',
      'eZNodeAssignment'                   => 'kernel/classes/eznodeassignment.php',
      'eZNodeviewfunctions'                => 'kernel/classes/eznodeviewfunctions.php',
      'eZNotificationCollection'           => 'kernel/classes/notification/eznotificationcollection.php',
      'eZNotificationCollectionItem'       => 'kernel/classes/notification/eznotificationcollectionitem.php',
      'eZNotificationEvent'                => 'kernel/classes/notification/eznotificationevent.php',
      'eZNotificationEventFilter'          => 'kernel/classes/notification/eznotificationeventfilter.php',
      'eZNotificationEventHandler'         => 'kernel/classes/notification/eznotificationeventhandler.php',
      'eZNotificationEventType'            => 'kernel/classes/notification/eznotificationeventtype.php',
      'eZNotificationFunctionCollection'   => 'kernel/notification/eznotificationfunctioncollection.php',
      'eZNotificationSchedule'             => 'kernel/classes/notification/eznotificationschedule.php',
      'eZNotificationTransport'            => 'kernel/classes/notification/eznotificationtransport.php',
      'eZNullDB'                           => 'lib/ezdb/classes/eznulldb.php',
      'eZObjectForwarder'                  => 'kernel/common/ezobjectforwarder.php',
      'eZObjectRelationListType'           => 'kernel/classes/datatypes/ezobjectrelationlist/ezobjectrelationlisttype.php',
      'eZObjectRelationType'               => 'kernel/classes/datatypes/ezobjectrelation/ezobjectrelationtype.php',
      'eZOperationHandler'                 => 'lib/ezutils/classes/ezoperationhandler.php',
      'eZOperationMemento'                 => 'lib/ezutils/classes/ezoperationmemento.php',
      'eZOption'                           => 'kernel/classes/datatypes/ezoption/ezoption.php',
      'eZOptionType'                       => 'kernel/classes/datatypes/ezoption/ezoptiontype.php',
      'eZOrder'                            => 'kernel/classes/ezorder.php',
      'eZOrderItem'                        => 'kernel/classes/ezorderitem.php',
      'eZOrderStatus'                      => 'kernel/classes/ezorderstatus.php',
      'eZOrderStatusHistory'               => 'kernel/classes/ezorderstatushistory.php',
      'eZOverride'                         => 'kernel/common/ezoverride.php',
      'eZPDF'                              => 'lib/ezpdf/classes/ezpdf.php',
      'eZPDFExport'                        => 'kernel/classes/ezpdfexport.php',
      'eZPDFParser'                        => 'kernel/classes/datatypes/ezbinaryfile/plugins/ezpdfparser.php',
      'eZPDFTable'                         => 'lib/ezpdf/classes/class.ezpdftable.php',
      'eZPDFXMLOutput'                     => 'kernel/classes/datatypes/ezxmltext/handlers/output/ezpdfxmloutput.php',
      'eZPHPCreator'                       => 'lib/ezutils/classes/ezphpcreator.php',
      'eZPHPMath'                          => 'lib/ezmath/classes/mathhandlers/ezphpmath.php',
      'eZPackage'                          => 'kernel/classes/ezpackage.php',
      'eZPackageCreationHandler'           => 'kernel/classes/ezpackagecreationhandler.php',
      'eZPackageFunctionCollection'        => 'kernel/package/ezpackagefunctioncollection.php',
      'eZPackageHandler'                   => 'kernel/classes/ezpackagehandler.php',
      'eZPackageInstallationHandler'       => 'kernel/classes/ezpackageinstallationhandler.php',
      'eZPackageOperator'                  => 'kernel/common/ezpackageoperator.php',
      'eZPackageType'                      => 'kernel/classes/datatypes/ezpackage/ezpackagetype.php',
      'eZPathElement'                      => 'kernel/classes/ezpathelement.php',
      'eZPaymentCallbackChecker'           => 'kernel/shop/classes/ezpaymentcallbackchecker.php',
      'eZPaymentGateway'                   => 'kernel/shop/classes/ezpaymentgateway.php',
      'eZPaymentGatewayType'               => 'kernel/classes/workflowtypes/event/ezpaymentgateway/ezpaymentgatewaytype.php',
      'eZPaymentLogger'                    => 'kernel/classes/workflowtypes/event/ezpaymentgateway/ezpaymentlogger.php',
      'eZPaymentObject'                    => 'kernel/shop/classes/ezpaymentobject.php',
      'eZPersistentObject'                 => 'kernel/classes/ezpersistentobject.php',
      'eZPgsqlSchema'                      => 'lib/ezdbschema/classes/ezpgsqlschema.php',
      'eZPlainTextParser'                  => 'kernel/classes/datatypes/ezbinaryfile/plugins/ezplaintextparser.php',
      'eZPlainXMLOutput'                   => 'kernel/classes/datatypes/ezxmltext/handlers/output/ezplainxmloutput.php',
      'eZPolicy'                           => 'kernel/classes/ezpolicy.php',
      'eZPolicyLimitation'                 => 'kernel/classes/ezpolicylimitation.php',
      'eZPolicyLimitationValue'            => 'kernel/classes/ezpolicylimitationvalue.php',
      'eZPostgreSQLDB'                     => 'lib/ezdb/classes/ezpostgresqldb.php',
      'eZPreferences'                      => 'kernel/classes/ezpreferences.php',
      'eZPrice'                            => 'kernel/classes/datatypes/ezprice/ezprice.php',
      'eZPriceType'                        => 'kernel/classes/datatypes/ezprice/ezpricetype.php',
      'eZProcess'                          => 'lib/ezutils/classes/ezprocess.php',
      'eZProductCategory'                  => 'kernel/classes/ezproductcategory.php',
      'eZProductCategoryType'              => 'kernel/classes/datatypes/ezproductcategory/ezproductcategorytype.php',
      'eZProductCollection'                => 'kernel/classes/ezproductcollection.php',
      'eZProductCollectionItem'            => 'kernel/classes/ezproductcollectionitem.php',
      'eZProductCollectionItemOption'      => 'kernel/classes/ezproductcollectionitemoption.php',
      'eZPublishSDK'                       => 'lib/version.php',
      'eZPublishType'                      => 'kernel/classes/notification/event/ezpublish/ezpublishtype.php',
      'eZRSSEditFunction'                  => 'kernel/rss/edit_functions.php',
      'eZRSSExport'                        => 'kernel/classes/ezrssexport.php',
      'eZRSSExportItem'                    => 'kernel/classes/ezrssexportitem.php',
      'eZRSSImport'                        => 'kernel/classes/ezrssimport.php',
      'eZRandomTranslator'                 => 'lib/ezi18n/classes/ezrandomtranslator.php',
      'eZRangeOption'                      => 'kernel/classes/datatypes/ezrangeoption/ezrangeoption.php',
      'eZRangeOptionType'                  => 'kernel/classes/datatypes/ezrangeoption/ezrangeoptiontype.php',
      'eZRedirectGateway'                  => 'kernel/shop/classes/ezredirectgateway.php',
      'eZRedirectManager'                  => 'kernel/classes/ezredirectmanager.php',
      'eZRegExpValidator'                  => 'lib/ezutils/classes/ezregexpvalidator.php',
      'eZRole'                             => 'kernel/classes/ezrole.php',
      'eZRoleFunctionCollection'           => 'kernel/role/ezrolefunctioncollection.php',
      'eZRunCronjobs'                      => 'runcronjobs.php',
      'eZSMTPTransport'                    => 'lib/ezutils/classes/ezsmtptransport.php',
      'eZSOAPBody'                         => 'lib/ezsoap/classes/ezsoapbody.php',
      'eZSOAPClient'                       => 'lib/ezsoap/classes/ezsoapclient.php',
      'eZSOAPCodec'                        => 'lib/ezsoap/classes/ezsoapcodec.php',
      'eZSOAPEnvelope'                     => 'lib/ezsoap/classes/ezsoapenvelope.php',
      'eZSOAPFault'                        => 'lib/ezsoap/classes/ezsoapfault.php',
      'eZSOAPHeader'                       => 'lib/ezsoap/classes/ezsoapheader.php',
      'eZSOAPParameter'                    => 'lib/ezsoap/classes/ezsoapparameter.php',
      'eZSOAPRequest'                      => 'lib/ezsoap/classes/ezsoaprequest.php',
      'eZSOAPResponse'                     => 'lib/ezsoap/classes/ezsoapresponse.php',
      'eZSOAPServer'                       => 'lib/ezsoap/classes/ezsoapserver.php',
      'eZSSLZone'                          => 'kernel/classes/ezsslzone.php',
      'eZSchema'                           => 'lib/ezxml/classes/ezschema.php',
      'eZSchemaElement'                    => 'lib/ezxml/classes/ezschemaelement.php',
      'eZScript'                           => 'kernel/classes/ezscript.php',
      'eZSearch'                           => 'kernel/classes/ezsearch.php',
      'eZSearchEngine'                     => 'kernel/search/plugins/ezsearchengine/ezsearchengine.php',
      'eZSearchFunctionCollection'         => 'kernel/search/ezsearchfunctioncollection.php',
      'eZSearchLog'                        => 'kernel/classes/ezsearchlog.php',
      'eZSection'                          => 'kernel/classes/ezsection.php',
      'eZSectionFunctionCollection'        => 'kernel/section/ezsectionfunctioncollection.php',
      'eZSelectionType'                    => 'kernel/classes/datatypes/ezselection/ezselectiontype.php',
      'eZSendmailTransport'                => 'lib/ezutils/classes/ezsendmailtransport.php',
      'eZSerializedObjectNameList'         => 'kernel/classes/ezserializedobjectnamelist.php',
      'eZSetupFunctionCollection'          => 'kernel/setup/ezsetupfunctioncollection.php',
      'eZSetupSummary'                     => 'kernel/setup/ezsetup_summary.php',
      'eZShippingManager'                  => 'kernel/classes/ezshippingmanager.php',
      'eZShopAccountHandler'               => 'kernel/classes/ezshopaccounthandler.php',
      'eZShopFunctionCollection'           => 'kernel/shop/ezshopfunctioncollection.php',
      'eZShopFunctions'                    => 'kernel/shop/classes/ezshopfunctions.php',
      'eZShopOperationCollection'          => 'kernel/shop/ezshopoperationcollection.php',
      'eZShuffleTranslator'                => 'lib/ezi18n/classes/ezshuffletranslator.php',
      'eZSimplePrice'                      => 'kernel/shop/classes/ezsimpleprice.php',
      'eZSimpleShippingType'               => 'kernel/classes/workflowtypes/event/ezsimpleshipping/ezsimpleshippingtype.php',
      'eZSimpleShopAccountHandler'         => 'kernel/classes/shopaccounthandlers/ezsimpleshopaccounthandler.php',
      'eZSimpleTagsOperator'               => 'kernel/common/ezsimpletagsoperator.php',
      'eZSimpleType'                       => 'lib/ezxml/classes/ezsimpletype.php',
      'eZSimplifiedXMLEditOutput'          => 'kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmleditoutput.php',
      'eZSimplifiedXMLInput'               => 'kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmlinput.php',
      'eZSimplifiedXMLInputParser'         => 'kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmlinputparser.php',
      'eZSiteAccess'                       => 'kernel/classes/ezsiteaccess.php',
      'eZSiteInstaller'                    => 'kernel/classes/ezsiteinstaller.php',
      'eZStaticCache'                      => 'kernel/classes/ezstaticcache.php',
      'eZStepCreateSites'                  => 'kernel/setup/steps/ezstep_create_sites.php',
      'eZStepData'                         => 'kernel/setup/steps/ezstep_data.php',
      'eZStepDatabaseChoice'               => 'kernel/setup/steps/ezstep_database_choice.php',
      'eZStepDatabaseInit'                 => 'kernel/setup/steps/ezstep_database_init.php',
      'eZStepEmailSettings'                => 'kernel/setup/steps/ezstep_email_settings.php',
      'eZStepFinal'                        => 'kernel/setup/steps/ezstep_final.php',
      'eZStepInstaller'                    => 'kernel/setup/steps/ezstep_installer.php',
      'eZStepLanguageOptions'              => 'kernel/setup/steps/ezstep_language_options.php',
      'eZStepPackageLanguageOptions'       => 'kernel/setup/steps/ezstep_package_language_options.php',
      'eZStepRegistration'                 => 'kernel/setup/steps/ezstep_registration.php',
      'eZStepSecurity'                     => 'kernel/setup/steps/ezstep_security.php',
      'eZStepSiteAccess'                   => 'kernel/setup/steps/ezstep_site_access.php',
      'eZStepSiteAdmin'                    => 'kernel/setup/steps/ezstep_site_admin.php',
      'eZStepSiteDetails'                  => 'kernel/setup/steps/ezstep_site_details.php',
      'eZStepSitePackages'                 => 'kernel/setup/steps/ezstep_site_packages.php',
      'eZStepSiteTemplates'                => 'kernel/setup/steps/ezstep_site_templates.php',
      'eZStepSiteTypes'                    => 'kernel/setup/steps/ezstep_site_types.php',
      'eZStepSystemCheck'                  => 'kernel/setup/steps/ezstep_system_check.php',
      'eZStepSystemFinetune'               => 'kernel/setup/steps/ezstep_system_finetune.php',
      'eZStepWelcome'                      => 'kernel/setup/steps/ezstep_welcome.php',
      'eZStringType'                       => 'kernel/classes/datatypes/ezstring/ezstringtype.php',
      'eZStringUtils'                      => 'lib/ezutils/classes/ezstringutils.php',
      'eZStylePackageCreator'              => 'kernel/classes/packagecreators/ezstyle/ezstylepackagecreator.php',
      'eZSubTreeHandler'                   => 'kernel/classes/notification/handler/ezsubtree/ezsubtreehandler.php',
      'eZSubtreeCache'                     => 'kernel/classes/ezsubtreecache.php',
      'eZSubtreeNotificationRule'          => 'kernel/classes/notification/handler/ezsubtree/ezsubtreenotificationrule.php',
      'eZSubtreeSubscriptionType'          => 'kernel/classes/datatypes/ezsubtreesubscription/ezsubtreesubscriptiontype.php',
      'eZSys'                              => 'lib/ezutils/classes/ezsys.php',
      'eZSysInfo'                          => 'lib/ezutils/classes/ezsysinfo.php',
      'eZTARArchiveHandler'                => 'lib/ezfile/classes/eztararchivehandler.php',
      'eZTOCOperator'                      => 'kernel/common/eztocoperator.php',
      'eZTSTranslator'                     => 'lib/ezi18n/classes/eztstranslator.php',
      'eZTemplate'                         => 'lib/eztemplate/classes/eztemplate.php',
      'eZTemplateArithmeticOperator'       => 'lib/eztemplate/classes/eztemplatearithmeticoperator.php',
      'eZTemplateArrayOperator'            => 'lib/eztemplate/classes/eztemplatearrayoperator.php',
      'eZTemplateAttributeOperator'        => 'lib/eztemplate/classes/eztemplateattributeoperator.php',
      'eZTemplateBlockFunction'            => 'lib/eztemplate/classes/eztemplateblockfunction.php',
      'eZTemplateCacheBlock'               => 'lib/eztemplate/classes/eztemplatecacheblock.php',
      'eZTemplateCacheFunction'            => 'lib/eztemplate/classes/eztemplatecachefunction.php',
      'eZTemplateCompiledLoop'             => 'lib/eztemplate/classes/eztemplatecompiledloop.php',
      'eZTemplateCompiler'                 => 'lib/eztemplate/classes/eztemplatecompiler.php',
      'eZTemplateControlOperator'          => 'lib/eztemplate/classes/eztemplatecontroloperator.php',
      'eZTemplateDebugFunction'            => 'lib/eztemplate/classes/eztemplatedebugfunction.php',
      'eZTemplateDefFunction'              => 'lib/eztemplate/classes/eztemplatedeffunction.php',
      'eZTemplateDelimitFunction'          => 'lib/eztemplate/classes/eztemplatedelimitfunction.php',
      'eZTemplateDesignResource'           => 'kernel/common/eztemplatedesignresource.php',
      'eZTemplateDigestOperator'           => 'lib/eztemplate/classes/eztemplatedigestoperator.php',
      'eZTemplateDoFunction'               => 'lib/eztemplate/classes/eztemplatedofunction.php',
      'eZTemplateElementParser'            => 'lib/eztemplate/classes/eztemplateelementparser.php',
      'eZTemplateExecuteOperator'          => 'lib/eztemplate/classes/eztemplateexecuteoperator.php',
      'eZTemplateFileResource'             => 'lib/eztemplate/classes/eztemplatefileresource.php',
      'eZTemplateForFunction'              => 'lib/eztemplate/classes/eztemplateforfunction.php',
      'eZTemplateForeachFunction'          => 'lib/eztemplate/classes/eztemplateforeachfunction.php',
      'eZTemplateFunctionElement'          => 'lib/eztemplate/classes/eztemplatefunctionelement.php',
      'eZTemplateIfFunction'               => 'lib/eztemplate/classes/eztemplateiffunction.php',
      'eZTemplateImageOperator'            => 'lib/eztemplate/classes/eztemplateimageoperator.php',
      'eZTemplateIncludeFunction'          => 'lib/eztemplate/classes/eztemplateincludefunction.php',
      'eZTemplateLocaleOperator'           => 'lib/eztemplate/classes/eztemplatelocaleoperator.php',
      'eZTemplateLogicOperator'            => 'lib/eztemplate/classes/eztemplatelogicoperator.php',
      'eZTemplateLoop'                     => 'lib/eztemplate/classes/eztemplateloop.php',
      'eZTemplateLoopSequence'             => 'lib/eztemplate/classes/eztemplateloop.php',
      'eZTemplateMenuFunction'             => 'lib/eztemplate/classes/eztemplatemenufunction.php',
      'eZTemplateMultiPassParser'          => 'lib/eztemplate/classes/eztemplatemultipassparser.php',
      'eZTemplateNl2BrOperator'            => 'lib/eztemplate/classes/eztemplatenl2broperator.php',
      'eZTemplateNodeTool'                 => 'lib/eztemplate/classes/eztemplatenodetool.php',
      'eZTemplateOperator'                 => 'lib/eztemplate/classes/eztemplateoperator.php',
      'eZTemplateOperatorElement'          => 'lib/eztemplate/classes/eztemplateoperatorelement.php',
      'eZTemplateOptimizer'                => 'lib/eztemplate/classes/eztemplateoptimizer.php',
      'eZTemplatePHPOperator'              => 'lib/eztemplate/classes/eztemplatephpoperator.php',
      'eZTemplateParser'                   => 'lib/eztemplate/classes/eztemplateparser.php',
      'eZTemplateRoot'                     => 'lib/eztemplate/classes/eztemplateroot.php',
      'eZTemplateSectionFunction'          => 'lib/eztemplate/classes/eztemplatesectionfunction.php',
      'eZTemplateSectionIterator'          => 'lib/eztemplate/classes/eztemplatesectioniterator.php',
      'eZTemplateSequenceFunction'         => 'lib/eztemplate/classes/eztemplatesequencefunction.php',
      'eZTemplateSetFunction'              => 'lib/eztemplate/classes/eztemplatesetfunction.php',
      'eZTemplateStringOperator'           => 'lib/eztemplate/classes/eztemplatestringoperator.php',
      'eZTemplateSwitchFunction'           => 'lib/eztemplate/classes/eztemplateswitchfunction.php',
      'eZTemplateTextElement'              => 'lib/eztemplate/classes/eztemplatetextelement.php',
      'eZTemplateTextOperator'             => 'lib/eztemplate/classes/eztemplatetextoperator.php',
      'eZTemplateToolbarFunction'          => 'lib/eztemplate/classes/eztemplatetoolbarfunction.php',
      'eZTemplateTreeCache'                => 'lib/eztemplate/classes/eztemplatetreecache.php',
      'eZTemplateTypeOperator'             => 'lib/eztemplate/classes/eztemplatetypeoperator.php',
      'eZTemplateUnitOperator'             => 'lib/eztemplate/classes/eztemplateunitoperator.php',
      'eZTemplateVariableElement'          => 'lib/eztemplate/classes/eztemplatevariableelement.php',
      'eZTemplateWhileFunction'            => 'lib/eztemplate/classes/eztemplatewhilefunction.php',
      'eZTemplatesStatisticsReporter'      => 'kernel/common/eztemplatesstatisticsreporter.php',
      'eZTextCodec'                        => 'lib/ezi18n/classes/eztextcodec.php',
      'eZTextDiff'                         => 'lib/ezdiff/classes/eztextdiff.php',
      'eZTextFileUser'                     => 'kernel/classes/datatypes/ezuser/eztextfileuser.php',
      'eZTextInputParser'                  => 'kernel/classes/eztextinputparser.php',
      'eZTextTool'                         => 'lib/ezutils/classes/eztexttool.php',
      'eZTextType'                         => 'kernel/classes/datatypes/eztext/eztexttype.php',
      'eZTime'                             => 'lib/ezlocale/classes/eztime.php',
      'eZTimeType'                         => 'kernel/classes/datatypes/eztime/eztimetype.php',
      'eZTipafriendCounter'                => 'kernel/classes/eztipafriendcounter.php',
      'eZTipafriendRequest'                => 'kernel/classes/eztipafriendrequest.php',
      'eZTopMenuOperator'                  => 'kernel/common/eztopmenuoperator.php',
      'eZTranslationCache'                 => 'lib/ezi18n/classes/eztranslationcache.php',
      'eZTranslatorGroup'                  => 'lib/ezi18n/classes/eztranslatorgroup.php',
      'eZTranslatorHandler'                => 'lib/ezi18n/classes/eztranslatorhandler.php',
      'eZTranslatorManager'                => 'lib/ezi18n/classes/eztranslatormanager.php',
      'eZTreeMenuOperator'                 => 'kernel/common/eztreemenuoperator.php',
      'eZTrigger'                          => 'kernel/classes/eztrigger.php',
      'eZURI'                              => 'lib/ezutils/classes/ezuri.php',
      'eZURL'                              => 'kernel/classes/datatypes/ezurl/ezurl.php',
      'eZURLAliasFilter'                   => 'kernel/classes/ezurlaliasfilter.php',
      'eZURLAliasML'                       => 'kernel/classes/ezurlaliasml.php',
      'eZURLAliasQuery'                    => 'kernel/classes/ezurlaliasquery.php',
      'eZURLFunctionCollection'            => 'kernel/url/ezurlfunctioncollection.php',
      'eZURLObjectLink'                    => 'kernel/classes/datatypes/ezurl/ezurlobjectlink.php',
      'eZURLOperator'                      => 'kernel/common/ezurloperator.php',
      'eZURLTranslator'                    => 'kernel/classes/ezurltranslator.php',
      'eZURLType'                          => 'kernel/classes/datatypes/ezurl/ezurltype.php',
      'eZURLWildcard'                      => 'kernel/classes/ezurlwildcard.php',
      'eZUTF8Codec'                        => 'lib/ezi18n/classes/ezutf8codec.php',
      'eZUser'                             => 'kernel/classes/datatypes/ezuser/ezuser.php',
      'eZUserAccountKey'                   => 'kernel/classes/datatypes/ezuser/ezuseraccountkey.php',
      'eZUserDiscountRule'                 => 'kernel/classes/ezuserdiscountrule.php',
      'eZUserFunctionCollection'           => 'kernel/user/ezuserfunctioncollection.php',
      'eZUserLoginHandler'                 => 'kernel/classes/datatypes/ezuser/ezuserloginhandler.php',
      'eZUserSetting'                      => 'kernel/classes/datatypes/ezuser/ezusersetting.php',
      'eZUserShopAccountHandler'           => 'kernel/classes/shopaccounthandlers/ezusershopaccounthandler.php',
      'eZUserType'                         => 'kernel/classes/datatypes/ezuser/ezusertype.php',
      'eZVATManager'                       => 'kernel/classes/ezvatmanager.php',
      'eZVatRule'                          => 'kernel/classes/ezvatrule.php',
      'eZVatType'                          => 'kernel/classes/ezvattype.php',
      'eZViewCounter'                      => 'kernel/classes/ezviewcounter.php',
      'eZWaitUntilDate'                    => 'kernel/classes/workflowtypes/event/ezwaituntildate/ezwaituntildate.php',
      'eZWaitUntilDateType'                => 'kernel/classes/workflowtypes/event/ezwaituntildate/ezwaituntildatetype.php',
      'eZWaitUntilDateValue'               => 'kernel/classes/workflowtypes/event/ezwaituntildate/ezwaituntildatevalue.php',
      'eZWeb'                              => 'lib/ezutils/classes/ezweb.php',
      'eZWebDAVContentServer'              => 'kernel/classes/webdav/ezwebdavcontentserver.php',
      'eZWebDAVFileServer'                 => 'lib/ezwebdav/classes/ezwebdavfileserver.php',
      'eZWebDAVServer'                     => 'lib/ezwebdav/classes/ezwebdavserver.php',
      'eZWishList'                         => 'kernel/classes/ezwishlist.php',
      'eZWizardBase'                       => 'lib/ezutils/classes/ezwizardbase.php',
      'eZWizardBaseClassLoader'            => 'lib/ezutils/classes/ezwizardbaseclassloader.php',
      'eZWordParser'                       => 'kernel/classes/datatypes/ezbinaryfile/plugins/ezwordparser.php',
      'eZWordToImageOperator'              => 'kernel/common/ezwordtoimageoperator.php',
      'eZWorkflow'                         => 'kernel/classes/ezworkflow.php',
      'eZWorkflowEvent'                    => 'kernel/classes/ezworkflowevent.php',
      'eZWorkflowEventType'                => 'kernel/classes/ezworkfloweventtype.php',
      'eZWorkflowFunctionCollection'       => 'kernel/workflow/ezworkflowfunctioncollection.php',
      'eZWorkflowFunctions'                => 'kernel/workflow/ezworkflowfunctions.php',
      'eZWorkflowGroup'                    => 'kernel/classes/ezworkflowgroup.php',
      'eZWorkflowGroupLink'                => 'kernel/classes/ezworkflowgrouplink.php',
      'eZWorkflowGroupType'                => 'kernel/classes/ezworkflowgrouptype.php',
      'eZWorkflowProcess'                  => 'kernel/classes/ezworkflowprocess.php',
      'eZWorkflowType'                     => 'kernel/classes/ezworkflowtype.php',
      'eZXHTMLXMLOutput'                   => 'kernel/classes/datatypes/ezxmltext/handlers/output/ezxhtmlxmloutput.php',
      'eZXML'                              => 'lib/ezxml/classes/ezxml.php',
      'eZXMLInputHandler'                  => 'kernel/classes/datatypes/ezxmltext/ezxmlinputhandler.php',
      'eZXMLInputParser'                   => 'kernel/classes/datatypes/ezxmltext/ezxmlinputparser.php',
      'eZXMLInputType'                     => 'kernel/classes/datatypes/ezxmltext/ezxmlinputtype.php',
      'eZXMLOutputHandler'                 => 'kernel/classes/datatypes/ezxmltext/ezxmloutputhandler.php',
      'eZXMLSchema'                        => 'kernel/classes/datatypes/ezxmltext/ezxmlschema.php',
      'eZXMLText'                          => 'kernel/classes/datatypes/ezxmltext/ezxmltext.php',
      'eZXMLTextDiff'                      => 'lib/ezdiff/classes/ezxmltextdiff.php',
      'eZXMLTextType'                      => 'kernel/classes/datatypes/ezxmltext/ezxmltexttype.php',
      'eZi18nOperator'                     => 'kernel/common/ezi18noperator.php',
      'openFts'                            => 'kernel/search/plugins/openfts/openfts.php',
      'smtp'                               => 'lib/ezutils/classes/ezsmtp.php',
    );

?>
