/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.packager.PackagerGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;
import org.eclipse.pde.internal.build.tasks.TaskHelper;

public class PackagerTask
extends Task {
    protected PackagerGenerator generator = new PackagerGenerator();

    public PackagerTask() {
        this.generator.setReportResolutionErrors(true);
        this.generator.setIgnoreMissingPropertiesFile(true);
        BuildTimeSiteFactory.setInstalledBaseSite(null);
    }

    public void setWorkingDirectory(String workingLocation) {
        this.generator.setWorkingDirectory(workingLocation);
    }

    public void setFeatureList(String featureList) throws BuildException {
        this.generator.setFeatureList(featureList);
    }

    public void setConfigInfo(String configInfo) throws CoreException {
        AbstractScriptGenerator.setConfigInfo((String)configInfo);
    }

    public void setArchivesFormat(String archivesFormat) throws CoreException {
        this.generator.setArchivesFormat(archivesFormat);
    }

    public void setBaseLocation(String baseLocation) throws BuildException {
        String[] locations = Utils.getArrayFromString((String)baseLocation);
        this.generator.setPluginPath(locations);
    }

    public void execute() throws BuildException {
        try {
            BundleHelper.getDefault().setLog((Object)this);
            this.generator.generate();
            BundleHelper.getDefault().setLog(null);
        }
        catch (CoreException e) {
            throw new BuildException(TaskHelper.statusToString(e.getStatus(), null).toString());
        }
    }

    public void setPackagePropertyFile(String propertyFile) {
        this.generator.setPropertyFile(propertyFile);
    }

    public void setDeltaPack(boolean value) {
        this.generator.includePlatformIndependent(!value);
        this.generator.groupConfigs(value);
    }
}

