/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.eclipse.jface.internal.databinding.internal.beans.JavaBeanObservableValue;
import org.eclipse.jface.internal.databinding.provisional.description.Property;
import org.eclipse.jface.internal.databinding.provisional.factories.IObservableFactory;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;

public class JavaBeansScalarObservableValueFactory
implements IObservableFactory {
    public IObservable createObservable(Object description) {
        if (!(description instanceof Property)) {
            return null;
        }
        Property property = (Property)description;
        Object collectionContainer = property.getObject();
        String propertyName = (String)property.getPropertyID();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(collectionContainer.getClass());
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        boolean found = false;
        int position = 0;
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        while (!found && position < pds.length) {
            if (pds[position].getName().equals(propertyName)) {
                found = true;
                break;
            }
            ++position;
        }
        if (!found) {
            return null;
        }
        JavaBeanObservableValue updatable = new JavaBeanObservableValue(collectionContainer, pds[position]);
        return updatable;
    }
}

