/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional;

import org.eclipse.jface.internal.databinding.provisional.conversion.IConverter;
import org.eclipse.jface.internal.databinding.provisional.validation.IDomainValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;

public class BindSpec {
    private IConverter[] modelToTargetConverters = new IConverter[1];
    private IConverter[] targetToModelConverters = new IConverter[1];
    private IValidator[] targetValidators = new IValidator[1];
    private IDomainValidator domainValidator;
    private Integer modelUpdatePolicy;
    private Integer validatePolicy;
    private Integer targetUpdatePolicy;
    private boolean updateModel = true;
    private boolean updateTarget = true;

    public BindSpec(IConverter modelToTargetConverter, IConverter targetToModelConverter, IValidator targetValidator, IDomainValidator domainValidator, Integer modelUpdatePolicy, Integer validatePolicy, Integer targetUpdatePolicy) {
        this.modelToTargetConverters[0] = modelToTargetConverter;
        this.targetToModelConverters[0] = targetToModelConverter;
        this.targetValidators[0] = targetValidator;
        this.domainValidator = domainValidator;
        this.modelUpdatePolicy = modelUpdatePolicy;
        this.validatePolicy = validatePolicy;
        this.targetUpdatePolicy = targetUpdatePolicy;
    }

    public BindSpec(IConverter[] modelToTargetConverter, IConverter[] targetToModelConverter, IValidator[] targetValidator, IDomainValidator domainValidator, Integer modelUpdatePolicy, Integer validatePolicy, Integer targetUpdatePolicy) {
        this.modelToTargetConverters = modelToTargetConverter;
        this.targetToModelConverters = targetToModelConverter;
        this.targetValidators = targetValidator;
        this.domainValidator = domainValidator;
        this.modelUpdatePolicy = modelUpdatePolicy;
        this.validatePolicy = validatePolicy;
        this.targetUpdatePolicy = targetUpdatePolicy;
    }

    public BindSpec(IConverter modelToTargetConverter, IConverter targetToModelConverter, IValidator targetValidator, IDomainValidator domainValidator) {
        this(modelToTargetConverter, targetToModelConverter, targetValidator, domainValidator, null, null, null);
    }

    public BindSpec() {
        this((IConverter)null, (IConverter)null, (IValidator)null, (IDomainValidator)null, (Integer)null, (Integer)null, (Integer)null);
    }

    public IConverter getModelToTargetConverter() {
        return this.modelToTargetConverters[0];
    }

    public IConverter[] getModelToTargetConverters() {
        return this.modelToTargetConverters;
    }

    public IConverter getTargetToModelConverter() {
        return this.targetToModelConverters[0];
    }

    public IConverter[] getTargetToModelConverters() {
        return this.targetToModelConverters;
    }

    public IValidator getTypeConversionValidator() {
        return this.targetValidators[0];
    }

    public IValidator[] getTypeConversionValidators() {
        return this.targetValidators;
    }

    public IDomainValidator getDomainValidator() {
        return this.domainValidator;
    }

    public Integer getModelUpdatePolicy() {
        return this.modelUpdatePolicy;
    }

    public Integer getValidatePolicy() {
        return this.validatePolicy;
    }

    public Integer getTargetUpdatePolicy() {
        return this.targetUpdatePolicy;
    }

    public BindSpec setModelToTargetConverter(IConverter converter) {
        this.modelToTargetConverters[0] = converter;
        return this;
    }

    public BindSpec setModelToTargetConverters(IConverter[] converters) {
        this.modelToTargetConverters = converters;
        return this;
    }

    public BindSpec setTargetToModelConverter(IConverter converter) {
        this.targetToModelConverters[0] = converter;
        return this;
    }

    public BindSpec setTargetToModelConverters(IConverter[] converters) {
        this.modelToTargetConverters = converters;
        return this;
    }

    public BindSpec setValidator(IValidator validator) {
        this.targetValidators[0] = validator;
        return this;
    }

    public BindSpec setValidators(IValidator[] validators) {
        this.targetValidators = validators;
        return this;
    }

    public BindSpec setDomainValidator(IDomainValidator validator) {
        this.domainValidator = validator;
        return this;
    }

    public boolean updateModel() {
        return this.updateModel;
    }

    public boolean updateTarget() {
        return this.updateTarget;
    }

    public BindSpec setUpdateModel(boolean updateModel) {
        this.updateModel = updateModel;
        return this;
    }

    public BindSpec setUpdateTarget(boolean updateTarget) {
        this.updateTarget = updateTarget;
        return this;
    }

    public BindSpec setModelUpdatePolicy(Integer modelUpdatePolicy) {
        this.modelUpdatePolicy = modelUpdatePolicy;
        return this;
    }

    public BindSpec setTargetUpdatePolicy(Integer targetUpdatePolicy) {
        this.targetUpdatePolicy = targetUpdatePolicy;
        return this;
    }

    public BindSpec setValidatePolicy(Integer validatePolicy) {
        this.validatePolicy = validatePolicy;
        return this;
    }
}

