/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Comparator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.ProblemView;
import org.eclipse.ui.views.markers.internal.TableSorter;
import org.eclipse.ui.views.markers.internal.Util;

public class CategorySorter
extends ViewerSorter
implements Comparator {
    TableSorter innerSorter;
    IField categoryField;
    private final String TAG_FIELD = "categoryField";

    CategorySorter(TableSorter sorter) {
        this.innerSorter = sorter;
    }

    int compare(Object obj1, Object obj2, int depth, boolean continueSearching) {
        if (obj1 == null || obj2 == null || !(obj1 instanceof MarkerNode) || !(obj2 instanceof MarkerNode)) {
            return 0;
        }
        MarkerNode marker1 = (MarkerNode)obj1;
        MarkerNode marker2 = (MarkerNode)obj2;
        if (this.categoryField == null) {
            return this.innerSorter.compare(marker1, marker2, depth, continueSearching);
        }
        int result = this.categoryField.compare(marker1, marker2);
        if (continueSearching && result == 0) {
            return this.innerSorter.compare(marker1, marker2, 0, continueSearching);
        }
        return result;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2, 0, true);
    }

    public int compare(Object arg0, Object arg1) {
        return this.compare(arg0, arg1, 0, true);
    }

    public IField getCategoryField() {
        return this.categoryField;
    }

    public void setCategoryField(IField field) {
        this.categoryField = field;
    }

    public void setTableSorter(TableSorter sorter2) {
        this.innerSorter = sorter2;
    }

    public void saveState(IDialogSettings dialogSettings) {
        if (dialogSettings == null) {
            return;
        }
        IDialogSettings settings = dialogSettings.getSection("sorter");
        if (settings == null) {
            settings = dialogSettings.addNewSection("sorter");
        }
        String description = Util.EMPTY_STRING;
        if (this.categoryField != null) {
            description = this.categoryField.getDescription();
        }
        settings.put("categoryField", description);
    }

    public void restoreState(IDialogSettings dialogSettings, ProblemView view) {
        if (dialogSettings == null) {
            this.selectDefaultGrouping(view);
            return;
        }
        IDialogSettings settings = dialogSettings.getSection("sorter");
        if (settings == null) {
            this.selectDefaultGrouping(view);
            return;
        }
        String description = settings.get("categoryField");
        view.selectCategory(description, this);
    }

    private void selectDefaultGrouping(ProblemView view) {
        view.selectCategoryField(MarkerSupportRegistry.getInstance().getDefaultGroup(), this);
    }
}

