/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.MethodBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class MethodBreakpointTypeChange
extends MethodBreakpointChange {
    private IType fDestType;

    public MethodBreakpointTypeChange(IJavaMethodBreakpoint breakpoint, IType destType) throws CoreException {
        super(breakpoint);
        this.fDestType = destType;
    }

    public String getName() {
        return RefactoringMessages.MethodBreakpointTypeChange_0;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IMethod destMethod = this.fDestType.getMethod(this.getMethodName(), Signature.getParameterTypes((String)this.getSignature()));
        HashMap map = new HashMap();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)destMethod);
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)destMethod);
        int[] range = this.getNewLineNumberAndRange((IMember)destMethod);
        IJavaMethodBreakpoint breakpoint = JDIDebugModel.createMethodBreakpoint((IResource)resource, (String)this.fDestType.getFullyQualifiedName(), (String)this.getMethodName(), (String)this.getSignature(), (boolean)this.isEntry(), (boolean)this.isExit(), (boolean)this.isNativeOnly(), (int)range[0], (int)range[1], (int)range[2], (int)this.getHitCount(), (boolean)true, map);
        this.apply(breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }
}

