/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import com.sun.jdi.connect.Connector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.AbstractJavaMainTab;
import org.eclipse.jdt.internal.debug.ui.launcher.ComboFieldEditor;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JavaConnectTab
extends AbstractJavaMainTab
implements IPropertyChangeListener {
    private Button fAllowTerminateButton;
    private Map fArgumentMap;
    private Map fFieldEditorMap = new HashMap();
    private Composite fArgumentComposite;
    private Combo fConnectorCombo;
    private IVMConnector fConnector;
    private IVMConnector[] fConnectors = JavaRuntime.getVMConnectors();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CONNECT_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createConnectionTypeControl(comp);
        this.createVerticalSpacer(comp, 1);
        this.createConnectionParamsControl(comp);
        this.createVerticalSpacer(comp, 2);
        this.fAllowTerminateButton = this.createCheckButton(comp, LauncherMessages.JavaConnectTab__Allow_termination_of_remote_VM_6);
        this.fAllowTerminateButton.addSelectionListener((SelectionListener)this.getDefaultListener());
    }

    private void createConnectionTypeControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(LauncherMessages.JavaConnectTab_Connect_ion_Type__7);
        group.setLayout((Layout)new GridLayout(2, true));
        group.setFont(font);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        this.fConnectorCombo = new Combo((Composite)group, 8);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fConnectorCombo.setLayoutData((Object)gd);
        this.fConnectorCombo.setFont(font);
        String[] names = new String[this.fConnectors.length];
        int i = 0;
        while (i < this.fConnectors.length) {
            names[i] = this.fConnectors[i].getName();
            ++i;
        }
        this.fConnectorCombo.setItems(names);
        this.fConnectorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaConnectTab.this.handleConnectorComboModified();
            }
        });
    }

    private void createConnectionParamsControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(LauncherMessages.JavaConnectTab_Connection_Properties_1);
        group.setLayout((Layout)new GridLayout());
        group.setFont(font);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Composite spacingComposite = new Composite((Composite)group, 0);
        spacingComposite.setLayout((Layout)new GridLayout(2, true));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        spacingComposite.setLayoutData((Object)gd);
        this.fArgumentComposite = spacingComposite;
        this.fArgumentComposite.setFont(font);
    }

    private void handleConnectorComboModified() {
        int index = this.fConnectorCombo.getSelectionIndex();
        if (index < 0 || index >= this.fConnectors.length) {
            return;
        }
        IVMConnector vm = this.fConnectors[index];
        if (vm.equals(this.fConnector)) {
            return;
        }
        this.fConnector = vm;
        try {
            this.fArgumentMap = vm.getDefaultArguments();
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(LauncherMessages.JavaConnectTab_Unable_to_display_connection_arguments__2, e.getStatus());
            return;
        }
        Control[] children = this.fArgumentComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.fFieldEditorMap.clear();
        PreferenceStore store = new PreferenceStore();
        for (String key : vm.getArgumentOrder()) {
            Connector.Argument arg = (Connector.Argument)this.fArgumentMap.get(key);
            Object field = null;
            if (arg instanceof Connector.IntegerArgument) {
                store.setDefault(arg.name(), ((Connector.IntegerArgument)arg).intValue());
                field = new IntegerFieldEditor(arg.name(), this.getLabel(arg.label()), this.fArgumentComposite);
            } else if (arg instanceof Connector.SelectedArgument) {
                List<String> choices = ((Connector.SelectedArgument)arg).choices();
                String[][] namesAndValues = new String[choices.size()][2];
                Iterator<String> iter = choices.iterator();
                int count = 0;
                while (iter.hasNext()) {
                    String choice;
                    namesAndValues[count][0] = choice = iter.next();
                    namesAndValues[count][1] = choice;
                    ++count;
                }
                store.setDefault(arg.name(), arg.value());
                field = new ComboFieldEditor(arg.name(), this.getLabel(arg.label()), namesAndValues, this.fArgumentComposite);
            } else if (arg instanceof Connector.StringArgument) {
                store.setDefault(arg.name(), arg.value());
                field = new StringFieldEditor(arg.name(), this.getLabel(arg.label()), this.fArgumentComposite);
            } else if (arg instanceof Connector.BooleanArgument) {
                store.setDefault(arg.name(), ((Connector.BooleanArgument)arg).booleanValue());
                field = new BooleanFieldEditor(arg.name(), this.getLabel(arg.label()), this.fArgumentComposite);
            }
            field.setPreferenceStore((IPreferenceStore)store);
            field.loadDefault();
            field.setPropertyChangeListener((IPropertyChangeListener)this);
            this.fFieldEditorMap.put(key, field);
        }
        this.fArgumentComposite.getParent().getParent().layout();
        this.fArgumentComposite.layout(true);
    }

    private String getLabel(String label) {
        if (!label.endsWith(":")) {
            label = String.valueOf(label) + ":";
        }
        return label;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateAllowTerminateFromConfig(config);
        this.updateConnectionFromConfig(config);
    }

    private void updateAllowTerminateFromConfig(ILaunchConfiguration config) {
        boolean allowTerminate = false;
        try {
            allowTerminate = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fAllowTerminateButton.setSelection(allowTerminate);
    }

    private void updateConnectionFromConfig(ILaunchConfiguration config) {
        String id = null;
        try {
            id = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, JavaRuntime.getDefaultVMConnector().getIdentifier());
            this.fConnectorCombo.setText(JavaRuntime.getVMConnector((String)id).getName());
            this.handleConnectorComboModified();
            Map attrMap = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
            if (attrMap == null) {
                return;
            }
            for (String key : attrMap.keySet()) {
                Connector.Argument arg = (Connector.Argument)this.fArgumentMap.get(key);
                FieldEditor editor = (FieldEditor)this.fFieldEditorMap.get(key);
                if (arg == null || editor == null) continue;
                String value = (String)attrMap.get(key);
                if (arg instanceof Connector.StringArgument || arg instanceof Connector.SelectedArgument) {
                    editor.getPreferenceStore().setValue(key, value);
                } else if (arg instanceof Connector.BooleanArgument) {
                    editor.getPreferenceStore().setValue(key, Boolean.valueOf(value).booleanValue());
                } else if (arg instanceof Connector.IntegerArgument) {
                    editor.getPreferenceStore().setValue(key, new Integer(value).intValue());
                }
                editor.load();
            }
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, this.fAllowTerminateButton.getSelection());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, this.getSelectedConnector().getIdentifier());
        this.mapResources(config);
        HashMap<String, String> attrMap = new HashMap<String, String>(this.fFieldEditorMap.size());
        for (String key : this.fFieldEditorMap.keySet()) {
            FieldEditor editor = (FieldEditor)this.fFieldEditorMap.get(key);
            if (!editor.isValid()) {
                return;
            }
            Connector.Argument arg = (Connector.Argument)this.fArgumentMap.get(key);
            editor.store();
            if (arg instanceof Connector.StringArgument || arg instanceof Connector.SelectedArgument) {
                attrMap.put(key, editor.getPreferenceStore().getString(key));
                continue;
            }
            if (arg instanceof Connector.BooleanArgument) {
                attrMap.put(key, Boolean.valueOf(editor.getPreferenceStore().getBoolean(key)).toString());
                continue;
            }
            if (!(arg instanceof Connector.IntegerArgument)) continue;
            attrMap.put(key, new Integer(editor.getPreferenceStore().getInt(key)).toString());
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, attrMap);
    }

    private void initializeDefaults(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        this.initializeJavaProject(javaElement, config);
        this.initializeName(javaElement, config);
        this.initializeHardCodedDefaults(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement == null) {
            this.initializeHardCodedDefaults(config);
        } else {
            this.initializeDefaults(javaElement, config);
        }
    }

    private void initializeName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = "";
        try {
            IResource resource = javaElement.getUnderlyingResource();
            if (resource != null) {
                name = resource.getName();
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
            } else {
                name = javaElement.getElementName();
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
        }
        catch (JavaModelException jme) {
            JDIDebugUIPlugin.log(jme);
        }
        config.rename(name);
    }

    private void initializeHardCodedDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, JavaRuntime.getDefaultVMConnector().getIdentifier());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(LauncherMessages.JavaConnectTab_Project_does_not_exist_14);
            return false;
        }
        for (String key : this.fFieldEditorMap.keySet()) {
            String value;
            Connector.Argument arg = (Connector.Argument)this.fArgumentMap.get(key);
            FieldEditor editor = (FieldEditor)this.fFieldEditorMap.get(key);
            if (!(editor instanceof StringFieldEditor) || arg.isValid(value = ((StringFieldEditor)editor).getStringValue())) continue;
            this.setErrorMessage(String.valueOf(arg.label()) + LauncherMessages.JavaConnectTab__is_invalid__5);
            return false;
        }
        return true;
    }

    public String getName() {
        return LauncherMessages.JavaConnectTab_Conn_ect_20;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
    }

    private IVMConnector getSelectedConnector() {
        return this.fConnector;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateLaunchConfigurationDialog();
    }
}

