/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.appserver.WebappManager;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.DisplayUtils;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.osgi.util.NLS;

public class HelpDisplay {
    public void displayHelp(boolean forceExternal) {
        if (HelpSystem.getTocs().length == 0) {
            HelpBasePlugin.logError("Failed launching help.  Documentation is not installed.", null);
            BaseHelpSystem.getDefaultErrorUtil().displayError(HelpBaseResources.HelpDisplay_docsNotInstalled);
            return;
        }
        this.displayHelpURL(null, forceExternal);
    }

    public void displayHelpResource(String href, boolean forceExternal) {
        ITocElement toc = HelpPlugin.getTocManager().getToc(href, Platform.getNL());
        if (toc != null) {
            try {
                this.displayHelpURL("toc=" + URLEncoder.encode(toc.getHref(), "UTF-8"), forceExternal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (href != null && (href.startsWith("tab=") || href.startsWith("toc=") || href.startsWith("topic=") || href.startsWith("contextId="))) {
            this.displayHelpURL(href, forceExternal);
        } else if (this.getNoframesURL(href) == null) {
            try {
                this.displayHelpURL("topic=" + URLEncoder.encode(href, "UTF-8"), forceExternal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (href.startsWith("jar:file:")) {
            this.displayHelpURL(String.valueOf(this.getBaseURL()) + "nftopic/" + this.getNoframesURL(href), true);
        } else {
            this.displayHelpURL(this.getNoframesURL(href), true);
        }
    }

    public void displayHelp(IContext context, IHelpResource topic, boolean forceExternal) {
        if (context == null || topic == null || topic.getHref() == null) {
            return;
        }
        String topicURL = this.getTopicURL(topic.getHref());
        if (this.getNoframesURL(topicURL) == null) {
            try {
                String url = "tab=links&contextId=" + URLEncoder.encode(this.getContextID(context), "UTF-8") + "&topic=" + URLEncoder.encode(topicURL, "UTF-8");
                this.displayHelpURL(url, forceExternal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (topicURL.startsWith("jar:file:")) {
            this.displayHelpURL(String.valueOf(this.getBaseURL()) + "nftopic/" + this.getNoframesURL(topicURL), true);
        } else {
            this.displayHelpURL(this.getNoframesURL(topicURL), true);
        }
    }

    public void displaySearch(String searchQuery, String topic, boolean forceExternal) {
        if (searchQuery == null || topic == null) {
            return;
        }
        if (this.getNoframesURL(topic) == null) {
            try {
                String url = "tab=search&" + searchQuery + "&topic=" + URLEncoder.encode(this.getTopicURL(topic), "UTF-8");
                this.displayHelpURL(url, forceExternal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            this.displayHelpURL(this.getNoframesURL(topic), true);
        }
    }

    private void displayHelpURL(String helpURL, boolean forceExternal) {
        if (!BaseHelpSystem.ensureWebappRunning()) {
            return;
        }
        if (BaseHelpSystem.getMode() == 2) {
            DisplayUtils.waitForDisplay();
        }
        try {
            if (helpURL == null || helpURL.length() == 0) {
                helpURL = this.getFramesetURL();
            } else if (helpURL.startsWith("tab=") || helpURL.startsWith("toc=") || helpURL.startsWith("topic=") || helpURL.startsWith("contextId=")) {
                helpURL = String.valueOf(this.getFramesetURL()) + "?" + helpURL;
            }
            BaseHelpSystem.getHelpBrowser(forceExternal).displayURL(helpURL);
        }
        catch (Exception e) {
            HelpBasePlugin.logError("An exception occurred while launching help.  Check the log at " + Platform.getLogFileLocation().toOSString(), e);
            BaseHelpSystem.getDefaultErrorUtil().displayError(NLS.bind((String)HelpBaseResources.HelpDisplay_exceptionMessage, (Object)Platform.getLogFileLocation().toOSString()));
        }
    }

    private String getContextID(IContext context) {
        if (context instanceof Context) {
            return ((Context)context).getID();
        }
        return HelpPlugin.getContextManager().addContext(context);
    }

    private String getBaseURL() {
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help/";
    }

    private String getFramesetURL() {
        return String.valueOf(this.getBaseURL()) + "index.jsp";
    }

    private String getTopicURL(String topic) {
        if (topic == null) {
            return null;
        }
        if (topic.startsWith("../")) {
            topic = topic.substring(2);
        }
        return topic;
    }

    private String getNoframesURL(String href) {
        if (href == null) {
            return null;
        }
        int ix = href.indexOf("?noframes=true&");
        if (ix >= 0) {
            return String.valueOf(href.substring(0, ix + 1)) + href.substring(ix + "?noframes=true&".length());
        }
        ix = href.indexOf("noframes=true");
        if (ix > 0) {
            return String.valueOf(href.substring(0, ix - 1)) + href.substring(ix + "noframes=true".length());
        }
        return null;
    }
}

