/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class IndentationTabPage
extends ModifyDialogTabPage {
    private final String PREVIEW = String.valueOf(IndentationTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header)) + "class Example {" + "  int [] myArray= {1,2,3,4,5,6};" + "  int theInt= 1;" + "  String someString= \"Hello\";" + "  double aDouble= 3.0;" + "  void foo(int a, int b, int c, int d, int e, int f) {" + "    switch(a) {" + "    case 0: " + "      Other.doFoo();" + "      break;" + "    default:" + "      Other.doBaz();" + "    }" + "  }" + "  void bar(List v) {" + "    for (int i= 0; i < 10; i++) {" + "      v.add(new Integer(i));" + "    }" + "  }" + "}" + "\n" + "enum MyEnum {" + "    UNDEFINED(0) {" + "        void foo() {}" + "    }" + "}" + "@interface MyAnnotation {" + "    int count() default 1;" + "}";
    private CompilationUnitPreview fPreview;
    private String fOldTabChar = null;

    public IndentationTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] tabPolicyValues = new String[]{"space", "tab", "mixed"};
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
        ModifyDialogTabPage.ComboPreference tabPolicy = this.createComboPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "org.eclipse.jdt.core.formatter.tabulation.char", tabPolicyValues, tabPolicyLabels);
        final ModifyDialogTabPage.CheckboxPreference onlyForLeading = this.createCheckboxPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_use_tabs_only_for_leading_indentations, "org.eclipse.jdt.core.formatter.use_tabs_only_for_leading_indentations", FALSE_TRUE);
        final ModifyDialogTabPage.NumberPreference indentSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "org.eclipse.jdt.core.formatter.tabulation.size", 0, 32);
        final ModifyDialogTabPage.NumberPreference tabSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "org.eclipse.jdt.core.formatter.tabulation.size", 0, 32);
        String tabchar = (String)this.fWorkingValues.get("org.eclipse.jdt.core.formatter.tabulation.char");
        this.updateTabPreferences(tabchar, tabSize, indentSize, onlyForLeading);
        tabPolicy.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                IndentationTabPage.this.updateTabPreferences((String)arg, tabSize, indentSize, onlyForLeading);
            }
        });
        tabSize.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                indentSize.updateWidget();
            }
        });
        Group typeMemberGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_field_alignment_group_title);
        this.createCheckboxPref((Composite)typeMemberGroup, numColumns, FormatterMessages.IndentationTabPage_field_alignment_group_align_fields_in_columns, "org.eclipse.jdt.core.formatter.align_type_members_on_columns", FALSE_TRUE);
        Group classGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_within_class_body, "org.eclipse.jdt.core.formatter.indent_body_declarations_compare_to_type_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_within_enum_decl, "org.eclipse.jdt.core.formatter.indent_body_declarations_compare_to_enum_declaration_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_within_enum_const, "org.eclipse.jdt.core.formatter.indent_body_declarations_compare_to_enum_constant_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_within_annot_decl, "org.eclipse.jdt.core.formatter.indent_body_declarations_compare_to_annotation_declaration_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_body, "org.eclipse.jdt.core.formatter.indent_statements_compare_to_body", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_block, "org.eclipse.jdt.core.formatter.indent_statements_compare_to_block", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_switch_body, "org.eclipse.jdt.core.formatter.indent_switchstatements_compare_to_switch", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_case_body, "org.eclipse.jdt.core.formatter.indent_switchstatements_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_break_statements, "org.eclipse.jdt.core.formatter.indent_breaks_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_indent_empty_lines, "org.eclipse.jdt.core.formatter.indent_empty_lines", FALSE_TRUE);
    }

    public void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }

    private void updateTabPreferences(String tabPolicy, ModifyDialogTabPage.NumberPreference tabPreference, ModifyDialogTabPage.NumberPreference indentPreference, ModifyDialogTabPage.CheckboxPreference onlyForLeading) {
        if ("mixed".equals(tabPolicy)) {
            if ("space".equals(this.fOldTabChar) || "tab".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.eclipse.jdt.core.formatter.tabulation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.eclipse.jdt.core.formatter.indentation.size");
            onlyForLeading.setEnabled(true);
        } else if ("space".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.eclipse.jdt.core.formatter.indentation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.eclipse.jdt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(false);
        } else if ("tab".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.eclipse.jdt.core.formatter.tabulation.size");
            indentPreference.setEnabled(false);
            indentPreference.setKey("org.eclipse.jdt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = tabPolicy;
    }

    private void swapTabValues() {
        Object tabSize = this.fWorkingValues.get("org.eclipse.jdt.core.formatter.tabulation.size");
        Object indentSize = this.fWorkingValues.get("org.eclipse.jdt.core.formatter.indentation.size");
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.tabulation.size", indentSize);
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.indentation.size", tabSize);
    }
}

