/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitDescriptorChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class ConvertAnonymousToNestedRefactoring
extends ScriptableRefactoring {
    private static final String ID_CONVERT_ANONYMOUS = "org.eclipse.jdt.ui.convert.anonymous";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_STATIC = "static";
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private int fVisibility;
    private boolean fDeclareFinal = true;
    private boolean fDeclareStatic;
    private String fClassName = "";
    private CodeGenerationSettings fSettings;
    private CompilationUnit fCompilationUnitNode;
    private AnonymousClassDeclaration fAnonymousInnerClassNode;
    private Set fClassNamesUsed;
    private boolean fSelfInitializing = false;

    public ConvertAnonymousToNestedRefactoring(ICompilationUnit unit, CodeGenerationSettings settings, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((unit == null || unit.exists() ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        if (unit != null) {
            this.fSettings = settings;
        }
    }

    public int[] getAvailableVisibilities() {
        if (this.isLocalInnerType()) {
            return new int[1];
        }
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public boolean isLocalInnerType() {
        return ASTNodes.getParent(ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class), 1) != null;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        Assert.isTrue((visibility == 2 || visibility == 0 || visibility == 4 || visibility == 1 ? 1 : 0) != 0);
        this.fVisibility = visibility;
    }

    public void setClassName(String className) {
        Assert.isNotNull((Object)className);
        this.fClassName = className;
    }

    public boolean canEnableSettingFinal() {
        return true;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setDeclareStatic(boolean declareStatic) {
        this.fDeclareStatic = declareStatic;
    }

    public String getName() {
        return RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
        if (result.hasFatalError()) {
            return result;
        }
        this.initAST(pm);
        if (this.fAnonymousInnerClassNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_place_caret);
        }
        if (!this.fSelfInitializing) {
            this.initializeDefaults();
        }
        if (this.getSuperConstructorBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_compile_errors);
        }
        if (this.getSuperTypeBinding().isLocal()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_extends_local_class);
        }
        return new RefactoringStatus();
    }

    private void initializeDefaults() {
        this.fVisibility = this.isLocalInnerType() ? 0 : 2;
        this.fDeclareStatic = this.mustInnerClassBeStatic();
    }

    private void initAST(IProgressMonitor pm) {
        this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider(this.fCu, true, pm);
        this.fAnonymousInnerClassNode = ConvertAnonymousToNestedRefactoring.getAnonymousInnerClass(NodeFinder.perform((ASTNode)this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength));
        if (this.fAnonymousInnerClassNode != null) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class);
            if (declaration instanceof TypeDeclaration) {
                TypeDeclaration[] nested = ((TypeDeclaration)declaration).getTypes();
                this.fClassNamesUsed = new HashSet(nested.length);
                int index = 0;
                while (index < nested.length) {
                    this.fClassNamesUsed.add(nested[index].getName().getIdentifier());
                    ++index;
                }
            } else {
                this.fClassNamesUsed = Collections.EMPTY_SET;
            }
        }
    }

    private static AnonymousClassDeclaration getAnonymousInnerClass(ASTNode node) {
        AnonymousClassDeclaration anon;
        if (node == null) {
            return null;
        }
        if (node instanceof AnonymousClassDeclaration) {
            return (AnonymousClassDeclaration)node;
        }
        if (node instanceof ClassInstanceCreation && (anon = ((ClassInstanceCreation)node).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        if ((node = ASTNodes.getNormalizedNode(node)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY && (anon = ((ClassInstanceCreation)node.getParent()).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        return (AnonymousClassDeclaration)ASTNodes.getParent(node, AnonymousClassDeclaration.class);
    }

    public RefactoringStatus validateInput() {
        RefactoringStatus result = Checks.checkTypeName(this.fClassName);
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fClassNamesUsed.contains(this.fClassName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_type_exists);
        }
        IMethodBinding superConstructorBinding = this.getSuperConstructorBinding();
        if (superConstructorBinding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_compile_errors);
        }
        if (this.fClassName.equals(superConstructorBinding.getDeclaringClass().getName())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_another_name);
        }
        if (this.classNameHidesEnclosingType()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name_hides);
        }
        return result;
    }

    private boolean accessesAnonymousFields() {
        List anonymousInnerFieldTypes = this.getAllEnclosingAnonymousTypesField();
        List accessedField = this.getAllAccessedFields();
        for (IVariableBinding variableBinding : anonymousInnerFieldTypes) {
            for (IVariableBinding variableBinding2 : accessedField) {
                if (!Bindings.equals((IBinding)variableBinding, (IBinding)variableBinding2)) continue;
                return true;
            }
        }
        return false;
    }

    private List getAllAccessedFields() {
        final ArrayList accessedFields = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(FieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                if (binding != null && !binding.isEnumConstant()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            public boolean visit(QualifiedName node) {
                IVariableBinding variable;
                IBinding binding = node.resolveBinding();
                if (binding != null && binding instanceof IVariableBinding && !(variable = (IVariableBinding)binding).isEnumConstant() && variable.isField()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            public boolean visit(SimpleName node) {
                IVariableBinding variable;
                IBinding binding = node.resolveBinding();
                if (binding != null && binding instanceof IVariableBinding && !(variable = (IVariableBinding)binding).isEnumConstant() && variable.isField()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            public boolean visit(SuperFieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                if (binding != null && !binding.isEnumConstant()) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }
        };
        this.fAnonymousInnerClassNode.accept(visitor);
        return accessedFields;
    }

    private List getAllEnclosingAnonymousTypesField() {
        ArrayList ans = new ArrayList();
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class);
        AnonymousClassDeclaration anonymous = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, 1);
        while (anonymous != null) {
            if (!ASTNodes.isParent((ASTNode)anonymous, (ASTNode)declaration)) break;
            ITypeBinding binding = anonymous.resolveBinding();
            if (binding != null) {
                ans.addAll(Arrays.asList(binding.getDeclaredFields()));
            }
            anonymous = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)anonymous, 1);
        }
        return ans;
    }

    private boolean classNameHidesEnclosingType() {
        ITypeBinding type = ((AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class)).resolveBinding();
        while (type != null) {
            if (this.fClassName.equals(type.getName())) {
                return true;
            }
            type = type.getDeclaringClass();
        }
        return false;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            RefactoringStatus status = this.validateInput();
            if (this.accessesAnonymousFields()) {
                status.merge(RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_anonymous_field_access));
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fCu, this.fCompilationUnitNode);
            ITypeBinding[] parameters = this.getTypeParameters();
            this.addNestedClass(rewrite, parameters);
            this.modifyConstructorCall(rewrite, parameters);
            Change change = this.createChange(rewrite);
            return change;
        }
        finally {
            pm.done();
        }
    }

    private ITypeBinding[] getTypeParameters() {
        ArrayList<ITypeBinding> parameters = new ArrayList<ITypeBinding>(4);
        ClassInstanceCreation creation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        if (this.fDeclareStatic) {
            TypeVariableFinder finder = new TypeVariableFinder();
            creation.accept((ASTVisitor)finder);
            return finder.getResult();
        }
        MethodDeclaration declaration = this.getEnclosingMethodDeclaration((ASTNode)creation);
        if (declaration != null) {
            ITypeBinding binding = null;
            TypeParameter parameter2 = null;
            for (TypeParameter parameter2 : declaration.typeParameters()) {
                binding = parameter2.resolveBinding();
                if (binding == null) continue;
                parameters.add(binding);
            }
        }
        TypeVariableFinder finder = new TypeVariableFinder();
        creation.accept((ASTVisitor)finder);
        ITypeBinding[] variables = finder.getResult();
        ArrayList<ITypeBinding> remove = new ArrayList<ITypeBinding>(4);
        boolean match = false;
        ITypeBinding binding = null;
        ITypeBinding variable = null;
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            match = false;
            binding = (ITypeBinding)iterator.next();
            int index = 0;
            while (index < variables.length) {
                variable = variables[index];
                if (variable.equals((Object)binding)) {
                    match = true;
                }
                ++index;
            }
            if (match) continue;
            remove.add(binding);
        }
        parameters.removeAll(remove);
        ITypeBinding[] result = new ITypeBinding[parameters.size()];
        parameters.toArray(result);
        return result;
    }

    private MethodDeclaration getEnclosingMethodDeclaration(ASTNode node) {
        ASTNode parent = node.getParent();
        if (parent != null) {
            if (parent instanceof AbstractTypeDeclaration) {
                return null;
            }
            if (parent instanceof MethodDeclaration) {
                return (MethodDeclaration)parent;
            }
            return this.getEnclosingMethodDeclaration(parent);
        }
        return null;
    }

    private Change createChange(CompilationUnitRewrite rewrite) throws CoreException {
        ITypeBinding binding = this.fAnonymousInnerClassNode.resolveBinding();
        Object[] labels = new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)binding.getDeclaringMethod(), JavaElementLabels.ALL_FULLY_QUALIFIED)};
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCu.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_descriptor_description_short;
        String header = Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_descriptor_description, labels);
        JavaRefactoringDescriptorComment comment = new JavaRefactoringDescriptorComment(this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_class_name_pattern, this.fClassName));
        String visibility = JdtFlags.getVisibilityString(this.fVisibility);
        if ("".equals(visibility)) {
            visibility = RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_visibility_pattern, visibility));
        if (this.fDeclareFinal && this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_final_static);
        } else if (this.fDeclareFinal) {
            comment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_final);
        } else if (this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_declare_static);
        }
        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_CONVERT_ANONYMOUS, project, description, comment.asString(), arguments, 786434);
        arguments.put("input", descriptor.elementToHandle((IJavaElement)this.fCu));
        arguments.put("name", this.fClassName);
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        arguments.put(ATTRIBUTE_STATIC, Boolean.valueOf(this.fDeclareStatic).toString());
        arguments.put(ATTRIBUTE_VISIBILITY, new Integer(this.fVisibility).toString());
        CompilationUnitDescriptorChange result = new CompilationUnitDescriptorChange(descriptor, RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_name, this.fCu);
        try {
            ITextFileBuffer buffer = RefactoringFileBuffers.acquire(this.fCu);
            TextEdit resultingEdits = rewrite.getASTRewrite().rewriteAST(buffer.getDocument(), this.fCu.getJavaProject().getOptions(true));
            TextChangeCompatibility.addTextEdit((TextChange)result, RefactoringCoreMessages.ConvertAnonymousToNestedRefactoring_edit_name, resultingEdits);
        }
        finally {
            RefactoringFileBuffers.release(this.fCu);
        }
        return result;
    }

    private void modifyConstructorCall(CompilationUnitRewrite rewrite, ITypeBinding[] parameters) {
        rewrite.getASTRewrite().replace(this.fAnonymousInnerClassNode.getParent(), this.createNewClassInstanceCreation(rewrite, parameters), null);
    }

    private ASTNode createNewClassInstanceCreation(CompilationUnitRewrite rewrite, ITypeBinding[] parameters) {
        AST ast = this.fAnonymousInnerClassNode.getAST();
        ClassInstanceCreation newClassCreation = ast.newClassInstanceCreation();
        newClassCreation.setAnonymousClassDeclaration(null);
        SimpleType type = null;
        if (parameters.length > 0) {
            ParameterizedType parameterized = ast.newParameterizedType((Type)ast.newSimpleType((Name)ast.newSimpleName(this.fClassName)));
            int index = 0;
            while (index < parameters.length) {
                parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getName())));
                ++index;
            }
            type = parameterized;
        } else {
            type = ast.newSimpleType((Name)ast.newSimpleName(this.fClassName));
        }
        newClassCreation.setType((Type)type);
        this.copyArguments(rewrite, newClassCreation);
        this.addArgumentsForLocalsUsedInInnerClass(rewrite, newClassCreation);
        return newClassCreation;
    }

    private void addArgumentsForLocalsUsedInInnerClass(CompilationUnitRewrite rewrite, ClassInstanceCreation newClassCreation) {
        IVariableBinding[] usedLocals = this.getUsedLocalVariables();
        int i = 0;
        while (i < usedLocals.length) {
            AST ast = this.fAnonymousInnerClassNode.getAST();
            IVariableBinding binding = usedLocals[i];
            Object name = null;
            name = binding.isEnumConstant() ? ast.newQualifiedName((Name)ast.newSimpleName(binding.getDeclaringClass().getName()), ast.newSimpleName(binding.getName())) : ast.newSimpleName(binding.getName());
            newClassCreation.arguments().add(name);
            ++i;
        }
    }

    private void copyArguments(CompilationUnitRewrite rewrite, ClassInstanceCreation newClassCreation) {
        Iterator iter = ((ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent()).arguments().iterator();
        while (iter.hasNext()) {
            newClassCreation.arguments().add(rewrite.getASTRewrite().createCopyTarget((ASTNode)((Expression)iter.next())));
        }
    }

    private void addNestedClass(CompilationUnitRewrite rewrite, ITypeBinding[] parameters) throws CoreException {
        AbstractTypeDeclaration declarations = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class);
        int index = ConvertAnonymousToNestedRefactoring.findIndexOfFistNestedClass(declarations.bodyDeclarations());
        if (index == -1) {
            index = 0;
        }
        rewrite.getASTRewrite().getListRewrite((ASTNode)declarations, declarations.getBodyDeclarationsProperty()).insertAt((ASTNode)this.createNewNestedClass(rewrite, parameters), index, null);
    }

    private static int findIndexOfFistNestedClass(List bodyDeclarations) {
        int i = 0;
        int n = bodyDeclarations.size();
        while (i < n) {
            BodyDeclaration each = (BodyDeclaration)bodyDeclarations.get(i);
            if (ConvertAnonymousToNestedRefactoring.isNestedType(each)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isNestedType(BodyDeclaration each) {
        if (!(each instanceof AbstractTypeDeclaration)) {
            return false;
        }
        return each.getParent() instanceof AbstractTypeDeclaration;
    }

    private AbstractTypeDeclaration createNewNestedClass(CompilationUnitRewrite rewrite, ITypeBinding[] parameters) throws CoreException {
        AST ast = this.fAnonymousInnerClassNode.getAST();
        TypeDeclaration declaration = ast.newTypeDeclaration();
        declaration.setInterface(false);
        declaration.setJavadoc(null);
        declaration.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.createModifiersForNestedClass()));
        declaration.setName(ast.newSimpleName(this.fClassName));
        TypeParameter parameter = null;
        int index = 0;
        while (index < parameters.length) {
            parameter = ast.newTypeParameter();
            parameter.setName(ast.newSimpleName(parameters[index].getName()));
            declaration.typeParameters().add(parameter);
            ++index;
        }
        this.setSuperType(declaration);
        this.removeInitializationFromDeclaredFields(rewrite);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu);
        ITextFileBuffer buffer = null;
        try {
            buffer = RefactoringFileBuffers.acquire(this.fCu);
            IDocument document = buffer.getDocument();
            IVariableBinding[] bindings = this.getUsedLocalVariables();
            for (BodyDeclaration body : this.fAnonymousInnerClassNode.bodyDeclarations()) {
                declaration.bodyDeclarations().add(this.createBodyDeclaration(rewrite, document, (IBinding[])bindings, body, delimiter));
            }
        }
        finally {
            if (buffer != null) {
                RefactoringFileBuffers.release(this.fCu);
            }
        }
        this.createFieldsForAccessedLocals(rewrite, (AbstractTypeDeclaration)declaration);
        this.createNewConstructorIfNeeded(rewrite, (AbstractTypeDeclaration)declaration);
        if (this.fSettings.createComments) {
            String[] parameterNames = new String[parameters.length];
            int index2 = 0;
            while (index2 < parameterNames.length) {
                parameterNames[index2] = parameters[index2].getName();
                ++index2;
            }
            String string = CodeGeneration.getTypeComment(rewrite.getCu(), this.fClassName, parameterNames, StubUtility.getLineDelimiterUsed((IJavaElement)rewrite.getCu()));
            if (string != null) {
                Javadoc javadoc = (Javadoc)rewrite.getASTRewrite().createStringPlaceholder(string, 29);
                declaration.setJavadoc(javadoc);
            }
        }
        return declaration;
    }

    private ASTNode createBodyDeclaration(CompilationUnitRewrite rewriter, IDocument document, IBinding[] bindings, BodyDeclaration body, String delimiter) {
        IJavaProject javaProject;
        final ASTRewrite rewrite = ASTRewrite.create((AST)rewriter.getAST());
        ITrackedNodePosition position = rewrite.track((ASTNode)body);
        final IBinding[] binding = new IBinding[1];
        final ASTNode[] newNode = new ASTNode[1];
        ArrayList<String> excludedFields = new ArrayList<String>();
        final AST ast = this.fAnonymousInnerClassNode.getAST();
        IJavaProject project = javaProject = this.fCu.getJavaProject();
        int index = 0;
        while (index < bindings.length) {
            String name;
            binding[0] = bindings[index];
            String fieldName = name = binding[0].getName();
            String oldName = name;
            if (binding[0] instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding[0];
                if (!variable.isEnumConstant()) {
                    if ((name = NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)project, (String)name)).equals(oldName)) {
                        name = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)project, (String)name);
                    }
                    fieldName = NamingConventions.suggestFieldNames((IJavaProject)project, (String)"", (String)name, (int)0, (int)2, (String[])excludedFields.toArray(new String[excludedFields.size()]))[0];
                    excludedFields.add(fieldName);
                    if (this.fSettings.useKeywordThis) {
                        FieldAccess access = ast.newFieldAccess();
                        access.setExpression((Expression)ast.newThisExpression());
                        access.setName(ast.newSimpleName(fieldName));
                        newNode[0] = access;
                    } else {
                        newNode[0] = ast.newSimpleName(fieldName);
                    }
                } else {
                    newNode[0] = ast.newSimpleName(fieldName);
                }
            }
            body.accept(new ASTVisitor(){

                public boolean visit(SimpleName node) {
                    IBinding resolved = node.resolveBinding();
                    if (binding[0].equals((Object)resolved)) {
                        rewrite.replace((ASTNode)node, ASTNode.copySubtree((AST)ast, (ASTNode)newNode[0]), null);
                    }
                    return false;
                }
            });
            ++index;
        }
        Document buffer = new Document(document.get());
        Map options = javaProject.getOptions(true);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(javaProject);
        TextEdit edit = rewrite.rewriteAST((IDocument)buffer, options);
        try {
            edit.apply((IDocument)buffer, 2);
            String trimmed = Strings.trimIndentation(buffer.get(position.getStartPosition(), position.getLength()), settings.tabWidth, settings.indentWidth, false);
            return rewriter.getASTRewrite().createStringPlaceholder(trimmed, 31);
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        return null;
    }

    private void removeInitializationFromDeclaredFields(CompilationUnitRewrite rewrite) {
        for (VariableDeclarationFragment fragment : this.getFieldsToInitializeInConstructor()) {
            Assert.isNotNull((Object)fragment.getInitializer());
            rewrite.getASTRewrite().remove((ASTNode)fragment.getInitializer(), null);
        }
    }

    private void createFieldsForAccessedLocals(CompilationUnitRewrite rewrite, AbstractTypeDeclaration declaration) {
        IVariableBinding[] bindings = this.getUsedLocalVariables();
        IJavaProject project = rewrite.getCu().getJavaProject();
        ArrayList<String> excluded = new ArrayList<String>();
        AST ast = this.fAnonymousInnerClassNode.getAST();
        int index = 0;
        while (index < bindings.length) {
            String name;
            VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
            fragment.setExtraDimensions(0);
            fragment.setInitializer(null);
            String oldName = name = bindings[index].getName();
            name = NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)project, (String)name);
            if (name.equals(oldName)) {
                name = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)project, (String)name);
            }
            name = NamingConventions.suggestFieldNames((IJavaProject)project, (String)"", (String)name, (int)0, (int)2, (String[])excluded.toArray(new String[excluded.size()]))[0];
            fragment.setName(ast.newSimpleName(name));
            excluded.add(name);
            FieldDeclaration field = ast.newFieldDeclaration(fragment);
            field.setType(rewrite.getImportRewrite().addImport(bindings[index].getType(), ast));
            field.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 18));
            declaration.bodyDeclarations().add(ConvertAnonymousToNestedRefactoring.findIndexOfLastField(declaration.bodyDeclarations()) + 1, field);
            if (this.fSettings.createComments) {
                try {
                    String string = CodeGeneration.getFieldComment(rewrite.getCu(), bindings[index].getType().getName(), name, StubUtility.getLineDelimiterUsed((IJavaElement)rewrite.getCu()));
                    if (string != null) {
                        Javadoc javadoc = (Javadoc)rewrite.getASTRewrite().createStringPlaceholder(string, 29);
                        field.setJavadoc(javadoc);
                    }
                }
                catch (CoreException exception) {
                    JavaPlugin.log(exception);
                }
            }
            ++index;
        }
    }

    private IVariableBinding[] getUsedLocalVariables() {
        HashSet result = new HashSet(0);
        this.fAnonymousInnerClassNode.accept(this.createTempUsageFinder(result));
        return result.toArray(new IVariableBinding[result.size()]);
    }

    private ASTVisitor createTempUsageFinder(final Set result) {
        return new ASTVisitor(){

            public boolean visit(SimpleName node) {
                IBinding binding = node.resolveBinding();
                if (ConvertAnonymousToNestedRefactoring.this.isBindingToTemp(binding)) {
                    result.add(binding);
                }
                return true;
            }
        };
    }

    private boolean isBindingToTemp(IBinding binding) {
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding variable = (IVariableBinding)binding;
        if (variable.isField()) {
            return false;
        }
        if (!Modifier.isFinal((int)binding.getModifiers())) {
            return false;
        }
        ASTNode declaringNode = this.fCompilationUnitNode.findDeclaringNode(binding);
        if (declaringNode == null) {
            return false;
        }
        return !ASTNodes.isParent(declaringNode, (ASTNode)this.fAnonymousInnerClassNode);
    }

    private void createNewConstructorIfNeeded(CompilationUnitRewrite rewrite, AbstractTypeDeclaration declaration) throws JavaModelException {
        IVariableBinding[] bindings = this.getUsedLocalVariables();
        if (((ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent()).arguments().isEmpty() && bindings.length == 0) {
            return;
        }
        AST ast = this.fAnonymousInnerClassNode.getAST();
        MethodDeclaration newConstructor = ast.newMethodDeclaration();
        newConstructor.setConstructor(true);
        newConstructor.setExtraDimensions(0);
        newConstructor.setJavadoc(null);
        newConstructor.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.fVisibility));
        newConstructor.setName(ast.newSimpleName(this.fClassName));
        ArrayList paramNames = new ArrayList();
        this.addParametersToNewConstructor(newConstructor, rewrite, paramNames);
        int paramCount = newConstructor.parameters().size();
        this.addParametersForLocalsUsedInInnerClass(rewrite, bindings, newConstructor, paramNames);
        Block body = ast.newBlock();
        if (paramCount > 0) {
            SuperConstructorInvocation superConstructorInvocation = ast.newSuperConstructorInvocation();
            int i = 0;
            while (i < paramCount) {
                SingleVariableDeclaration param = (SingleVariableDeclaration)newConstructor.parameters().get(i);
                superConstructorInvocation.arguments().add(ast.newSimpleName(param.getName().getIdentifier()));
                ++i;
            }
            body.statements().add(superConstructorInvocation);
        }
        IJavaProject project = this.fCu.getJavaProject();
        ArrayList<String> excludedFields = new ArrayList<String>();
        ArrayList<String> excludedParams = new ArrayList<String>();
        int index = 0;
        while (index < bindings.length) {
            String name;
            String fieldName = name = bindings[index].getName();
            String paramName = name;
            String oldName = name;
            if ((name = NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)project, (String)name)).equals(oldName)) {
                name = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)project, (String)name);
            }
            fieldName = NamingConventions.suggestFieldNames((IJavaProject)project, (String)"", (String)name, (int)0, (int)2, (String[])excludedFields.toArray(new String[excludedFields.size()]))[0];
            excludedFields.add(fieldName);
            paramName = NamingConventions.suggestArgumentNames((IJavaProject)project, (String)"", (String)name, (int)0, (String[])excludedParams.toArray(new String[excludedParams.size()]))[0];
            excludedParams.add(paramName);
            Assignment assignmentExpression = ast.newAssignment();
            assignmentExpression.setOperator(Assignment.Operator.ASSIGN);
            if (this.fSettings.useKeywordThis || fieldName.equals(paramName)) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(fieldName));
                assignmentExpression.setLeftHandSide((Expression)access);
            } else {
                assignmentExpression.setLeftHandSide((Expression)ast.newSimpleName(fieldName));
            }
            assignmentExpression.setRightHandSide((Expression)ast.newSimpleName(paramName));
            ExpressionStatement assignmentStatement = ast.newExpressionStatement((Expression)assignmentExpression);
            body.statements().add(assignmentStatement);
            ++index;
        }
        this.addFieldInitialization(rewrite, body);
        newConstructor.setBody(body);
        this.addExceptionsToNewConstructor(newConstructor);
        declaration.bodyDeclarations().add(1 + bindings.length + ConvertAnonymousToNestedRefactoring.findIndexOfLastField(this.fAnonymousInnerClassNode.bodyDeclarations()), newConstructor);
        if (this.fSettings.createComments) {
            try {
                String string = CodeGeneration.getMethodComment(rewrite.getCu(), this.fClassName, this.fClassName, paramNames.toArray(new String[paramNames.size()]), new String[0], null, new String[0], null, StubUtility.getLineDelimiterUsed((IJavaElement)rewrite.getCu()));
                if (string != null) {
                    Javadoc javadoc = (Javadoc)rewrite.getASTRewrite().createStringPlaceholder(string, 29);
                    newConstructor.setJavadoc(javadoc);
                }
            }
            catch (CoreException exception) {
                JavaPlugin.log(exception);
            }
        }
    }

    private void addFieldInitialization(CompilationUnitRewrite rewrite, Block constructorBody) {
        IJavaProject project = rewrite.getCu().getJavaProject();
        ArrayList<String> excluded = new ArrayList<String>();
        AST ast = this.fAnonymousInnerClassNode.getAST();
        for (VariableDeclarationFragment fragment : this.getFieldsToInitializeInConstructor()) {
            String name;
            Assignment assignmentExpression = ast.newAssignment();
            assignmentExpression.setOperator(Assignment.Operator.ASSIGN);
            String oldName = name = fragment.getName().getIdentifier();
            name = NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)project, (String)name);
            if (name.equals(oldName)) {
                name = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)project, (String)name);
            }
            name = NamingConventions.suggestFieldNames((IJavaProject)project, (String)"", (String)name, (int)0, (int)2, (String[])excluded.toArray(new String[excluded.size()]))[0];
            if (this.fSettings.useKeywordThis) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(name));
                assignmentExpression.setLeftHandSide((Expression)access);
            } else {
                assignmentExpression.setLeftHandSide((Expression)ast.newSimpleName(name));
            }
            excluded.add(name);
            Expression rhs = (Expression)rewrite.getASTRewrite().createCopyTarget((ASTNode)fragment.getInitializer());
            assignmentExpression.setRightHandSide(rhs);
            ExpressionStatement assignmentStatement = ast.newExpressionStatement((Expression)assignmentExpression);
            constructorBody.statements().add(assignmentStatement);
        }
    }

    private List getFieldsToInitializeInConstructor() {
        ArrayList<VariableDeclarationFragment> result = new ArrayList<VariableDeclarationFragment>(0);
        for (BodyDeclaration element : this.fAnonymousInnerClassNode.bodyDeclarations()) {
            if (!(element instanceof FieldDeclaration)) continue;
            FieldDeclaration field = (FieldDeclaration)element;
            for (VariableDeclarationFragment fragment : field.fragments()) {
                if (!this.isToBeInitializerInConstructor(fragment)) continue;
                result.add(fragment);
            }
        }
        return result;
    }

    private boolean isToBeInitializerInConstructor(VariableDeclarationFragment fragment) {
        if (fragment.getInitializer() == null) {
            return false;
        }
        return this.areLocalsUsedIn(fragment.getInitializer());
    }

    private boolean areLocalsUsedIn(Expression fieldInitializer) {
        HashSet localsUsed = new HashSet(0);
        fieldInitializer.accept(this.createTempUsageFinder(localsUsed));
        return !localsUsed.isEmpty();
    }

    private void addParametersForLocalsUsedInInnerClass(CompilationUnitRewrite rewrite, IVariableBinding[] usedLocals, MethodDeclaration newConstructor, List params) {
        ArrayList<String> excluded = new ArrayList<String>();
        int index = 0;
        while (index < usedLocals.length) {
            SingleVariableDeclaration declaration = this.createNewParamDeclarationNode(usedLocals[index].getName(), usedLocals[index].getType(), rewrite, excluded.toArray(new String[excluded.size()]));
            newConstructor.parameters().add(declaration);
            String identifier = declaration.getName().getIdentifier();
            excluded.add(identifier);
            params.add(identifier);
            ++index;
        }
    }

    private IMethodBinding getSuperConstructorBinding() {
        IMethodBinding anonConstr = ((ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent()).resolveConstructorBinding();
        if (anonConstr == null) {
            return null;
        }
        ITypeBinding superClass = anonConstr.getDeclaringClass().getSuperclass();
        IMethodBinding[] superMethods = superClass.getDeclaredMethods();
        int i = 0;
        while (i < superMethods.length) {
            IMethodBinding superMethod = superMethods[i];
            if (superMethod.isConstructor() && ConvertAnonymousToNestedRefactoring.parameterTypesMatch(superMethod, anonConstr)) {
                return superMethod;
            }
            ++i;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static boolean parameterTypesMatch(IMethodBinding m1, IMethodBinding m2) {
        ITypeBinding[] m2Params;
        ITypeBinding[] m1Params = m1.getParameterTypes();
        if (m1Params.length != (m2Params = m2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < m2Params.length) {
            if (!m1Params[i].equals((Object)m2Params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addExceptionsToNewConstructor(MethodDeclaration newConstructor) {
        IMethodBinding constructorBinding = this.getSuperConstructorBinding();
        if (constructorBinding == null) {
            return;
        }
        ITypeBinding[] exceptions = constructorBinding.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            Name exceptionTypeName = this.fAnonymousInnerClassNode.getAST().newName(Bindings.getNameComponents(exceptions[i]));
            newConstructor.thrownExceptions().add(exceptionTypeName);
            ++i;
        }
    }

    private void addParametersToNewConstructor(MethodDeclaration newConstructor, CompilationUnitRewrite rewrite, List params) throws JavaModelException {
        IMethodBinding constructorBinding = this.getSuperConstructorBinding();
        if (constructorBinding == null) {
            return;
        }
        ITypeBinding[] paramTypes = constructorBinding.getParameterTypes();
        IMethod method = (IMethod)constructorBinding.getJavaElement();
        if (method == null) {
            return;
        }
        String[] parameterNames = method.getParameterNames();
        ArrayList<String> excluded = new ArrayList<String>();
        int index = 0;
        while (index < parameterNames.length) {
            SingleVariableDeclaration declaration = this.createNewParamDeclarationNode(parameterNames[index], paramTypes[index], rewrite, excluded.toArray(new String[excluded.size()]));
            newConstructor.parameters().add(declaration);
            String identifier = declaration.getName().getIdentifier();
            excluded.add(identifier);
            params.add(identifier);
            ++index;
        }
    }

    private SingleVariableDeclaration createNewParamDeclarationNode(String paramName, ITypeBinding paramType, CompilationUnitRewrite rewrite, String[] excluded) {
        SingleVariableDeclaration param = this.fAnonymousInnerClassNode.getAST().newSingleVariableDeclaration();
        param.setExtraDimensions(0);
        param.setInitializer(null);
        IJavaProject project = rewrite.getCu().getJavaProject();
        String name = NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)project, (String)paramName);
        if (name.equals(paramName)) {
            name = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)project, (String)paramName);
        }
        name = NamingConventions.suggestArgumentNames((IJavaProject)project, (String)"", (String)name, (int)0, (String[])excluded)[0];
        param.setName(this.fAnonymousInnerClassNode.getAST().newSimpleName(name));
        param.setType(rewrite.getImportRewrite().addImport(paramType, this.fAnonymousInnerClassNode.getAST()));
        return param;
    }

    private void setSuperType(TypeDeclaration declaration) throws JavaModelException {
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
        ITypeBinding binding = classInstanceCreation.resolveTypeBinding();
        if (binding == null) {
            return;
        }
        Type newType = (Type)ASTNode.copySubtree((AST)this.fAnonymousInnerClassNode.getAST(), (ASTNode)classInstanceCreation.getType());
        if (binding.getSuperclass().getQualifiedName().equals("java.lang.Object")) {
            Assert.isTrue((binding.getInterfaces().length <= 1 ? 1 : 0) != 0);
            if (binding.getInterfaces().length == 0) {
                return;
            }
            declaration.superInterfaceTypes().add(0, newType);
        } else {
            declaration.setSuperclassType(newType);
        }
    }

    private ITypeBinding getSuperTypeBinding() {
        ITypeBinding types = this.fAnonymousInnerClassNode.resolveBinding();
        ITypeBinding[] interfaces = types.getInterfaces();
        if (interfaces.length > 0) {
            return interfaces[0];
        }
        return types.getSuperclass();
    }

    private int createModifiersForNestedClass() {
        int flags = this.fVisibility;
        if (this.fDeclareFinal) {
            flags |= 0x10;
        }
        if (this.mustInnerClassBeStatic() || this.fDeclareStatic) {
            flags |= 8;
        }
        return flags;
    }

    public boolean mustInnerClassBeStatic() {
        ITypeBinding typeBinding = ((AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, AbstractTypeDeclaration.class)).resolveBinding();
        ASTNode current = this.fAnonymousInnerClassNode.getParent();
        boolean ans = false;
        while (current != null) {
            switch (current.getNodeType()) {
                case 1: {
                    AnonymousClassDeclaration enclosingAnonymousClassDeclaration = (AnonymousClassDeclaration)current;
                    ITypeBinding binding = enclosingAnonymousClassDeclaration.resolveBinding();
                    if (binding == null || !Bindings.isSuperType(typeBinding, binding.getSuperclass())) break;
                    return false;
                }
                case 23: {
                    FieldDeclaration enclosingFieldDeclaration = (FieldDeclaration)current;
                    if (!Modifier.isStatic((int)enclosingFieldDeclaration.getModifiers())) break;
                    ans = true;
                    break;
                }
                case 31: {
                    MethodDeclaration enclosingMethodDeclaration = (MethodDeclaration)current;
                    if (!Modifier.isStatic((int)enclosingMethodDeclaration.getModifiers())) break;
                    ans = true;
                    break;
                }
                case 55: {
                    return ans;
                }
            }
            current = current.getParent();
        }
        return ans;
    }

    private static int findIndexOfLastField(List bodyDeclarations) {
        int i = bodyDeclarations.size() - 1;
        while (i >= 0) {
            BodyDeclaration each = (BodyDeclaration)bodyDeclarations.get(i);
            if (each instanceof FieldDeclaration) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String declareStatic;
        this.fSelfInitializing = true;
        if (arguments instanceof JavaRefactoringArguments) {
            int length;
            int offset;
            String selection;
            IJavaElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 5) {
                    return this.createInputFatalStatus(element, ID_CONVERT_ANONYMOUS);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (ICompilationUnit)element;
            this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fCu.getJavaProject());
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fClassName = name;
            String visibility = extended.getAttribute(ATTRIBUTE_VISIBILITY);
            if (visibility != null && !"".equals(visibility)) {
                int flag = 0;
                try {
                    flag = Integer.parseInt(visibility);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = flag;
            }
            if ((selection = extended.getAttribute("selection")) != null) {
                offset = -1;
                length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset < 0 || length < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = offset;
            this.fSelectionLength = length;
            declareStatic = extended.getAttribute(ATTRIBUTE_STATIC);
            if (declareStatic == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_STATIC));
            }
            this.fDeclareStatic = Boolean.valueOf(declareStatic);
            String declareFinal = extended.getAttribute(ATTRIBUTE_FINAL);
            if (declareFinal == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDeclareFinal = Boolean.valueOf(declareStatic);
        return new RefactoringStatus();
    }

    public static class TypeVariableFinder
    extends ASTVisitor {
        private final Map fBindings = new HashMap();
        private final List fFound = new ArrayList();

        public final boolean visit(SimpleName node) {
            Assert.isNotNull((Object)node);
            ITypeBinding binding = node.resolveTypeBinding();
            if (binding != null && binding.isTypeVariable() && !this.fBindings.containsKey(binding.getKey())) {
                this.fBindings.put(binding.getKey(), binding);
                this.fFound.add(binding);
            }
            return true;
        }

        public final ITypeBinding[] getResult() {
            ITypeBinding[] result = new ITypeBinding[this.fFound.size()];
            this.fFound.toArray(result);
            return result;
        }
    }
}

