/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;

public abstract class AbstractJavaElementRenameChange
extends JDTChange {
    private final String fNewName;
    private final String fOldName;
    private final IPath fResourcePath;
    private final long fStampToRestore;
    private final String fComment;
    private final RefactoringDescriptor fDescriptor;

    protected AbstractJavaElementRenameChange(RefactoringDescriptor descriptor, IPath resourcePath, String oldName, String newName, String comment) {
        this(descriptor, resourcePath, oldName, newName, comment, -1L);
    }

    protected AbstractJavaElementRenameChange(RefactoringDescriptor descriptor, IPath resourcePath, String oldName, String newName, String comment, long stampToRestore) {
        Assert.isNotNull((Object)newName, (String)"new name");
        Assert.isNotNull((Object)oldName, (String)"old name");
        this.fDescriptor = descriptor;
        this.fResourcePath = resourcePath;
        this.fOldName = oldName;
        this.fNewName = newName;
        this.fComment = comment;
        this.fStampToRestore = stampToRestore;
    }

    protected final IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public Object getModifiedElement() {
        return JavaCore.create((IResource)this.getResource());
    }

    protected abstract Change createUndoChange(long var1) throws CoreException;

    protected abstract void doRename(IProgressMonitor var1) throws CoreException;

    protected abstract IPath createNewPath();

    public final Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.AbstractRenameChange_Renaming, 1);
            IResource resource = this.getResource();
            IPath newPath = this.createNewPath();
            Change result = this.createUndoChange(resource.getModificationStamp());
            this.doRename((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (this.fStampToRestore != -1L) {
                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
                newResource.revertModificationStamp(this.fStampToRestore);
            }
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getComment() {
        return this.fComment;
    }

    protected IPath getResourcePath() {
        return this.fResourcePath;
    }

    public String getOldName() {
        return this.fOldName;
    }

    public final ChangeDescriptor getDescriptor() {
        if (this.fDescriptor != null) {
            return new RefactoringChangeDescriptor(this.fDescriptor);
        }
        return null;
    }
}

