/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;

public class Resources {
    private Resources() {
    }

    public static IStatus checkInSync(IResource resource) {
        return Resources.checkInSync(new IResource[]{resource});
    }

    public static IStatus checkInSync(IResource[] resources) {
        IStatus result = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isSynchronized(2)) {
                result = Resources.addOutOfSync(result, resource);
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return new Status(0, JUnitPlugin.getPluginId(), 0, "", null);
    }

    public static IStatus makeCommittable(IResource resource, Object context) {
        return Resources.makeCommittable(new IResource[]{resource}, context);
    }

    public static IStatus makeCommittable(IResource[] resources, Object context) {
        ArrayList<IResource> readOnlyFiles = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1 && resource.getResourceAttributes().isReadOnly()) {
                readOnlyFiles.add(resource);
            }
            ++i;
        }
        if (readOnlyFiles.size() == 0) {
            return new Status(0, JUnitPlugin.getPluginId(), 0, "", null);
        }
        Map oldTimeStamps = Resources.createModificationStampMap(readOnlyFiles);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]), context);
        if (!status.isOK()) {
            return status;
        }
        IStatus modified = null;
        Map newTimeStamps = Resources.createModificationStampMap(readOnlyFiles);
        for (IFile file : oldTimeStamps.keySet()) {
            if (oldTimeStamps.get(file).equals(newTimeStamps.get(file))) continue;
            modified = Resources.addModified(modified, file);
        }
        if (modified != null) {
            return modified;
        }
        return new Status(0, JUnitPlugin.getPluginId(), 0, "", null);
    }

    private static Map createModificationStampMap(List files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        for (IFile file : files) {
            map.put(file, new Long(file.getModificationStamp()));
        }
        return map;
    }

    private static IStatus addModified(IStatus status, IFile file) {
        IStatus entry = JUnitStatus.createError(Messages.format(JUnitMessages.Resources_fileModified, file.getFullPath().toString()));
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add(entry);
            return status;
        }
        MultiStatus result = new MultiStatus(JUnitPlugin.getPluginId(), 10003, JUnitMessages.Resources_modifiedResources, null);
        result.add(status);
        result.add(entry);
        return result;
    }

    private static IStatus addOutOfSync(IStatus status, IResource resource) {
        Status entry = new Status(4, "org.eclipse.core.resources", 274, Messages.format(JUnitMessages.Resources_outOfSync, resource.getFullPath().toString()), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 274, JUnitMessages.Resources_outOfSyncResources, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }
}

