/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class JUnitLaunchDescription {
    static final String[] ATTRIBUTES_THAT_MUST_MATCH = new String[]{IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "org.eclipse.jdt.junit.CONTAINER", IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.jdt.junit.TESTNAME"};
    static final String EMPTY = "";
    private static final String DEFAULT_VALUE = "";
    private Map fAttributes = new HashMap();
    private final IJavaElement fElement;
    private final String fName;

    public JUnitLaunchDescription(IJavaElement element, String name) {
        this.fElement = element;
        this.fName = name;
        this.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.getProjectName());
    }

    public void copyAttributesInto(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.getProjectName());
        wc.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
        Set definedAttributes = this.getDefinedAttributes();
        for (Map.Entry attribute : definedAttributes) {
            wc.setAttribute((String)attribute.getKey(), (String)attribute.getValue());
        }
    }

    public boolean equals(Object arg0) {
        JUnitLaunchDescription desc = (JUnitLaunchDescription)arg0;
        return this.areEqual(desc.fElement, this.fElement) && this.areEqual(desc.fName, this.fName) && this.areEqual(desc.fAttributes, this.fAttributes);
    }

    public String getAttribute(String attr) {
        if (this.fAttributes.containsKey(attr)) {
            return (String)this.fAttributes.get(attr);
        }
        return "";
    }

    public String getContainer() {
        return this.getAttribute("org.eclipse.jdt.junit.CONTAINER");
    }

    public Set getDefinedAttributes() {
        return this.fAttributes.entrySet();
    }

    public IJavaElement getElement() {
        return this.fElement;
    }

    public String getName() {
        return this.fName;
    }

    public JUnitLaunchDescription setContainer(String handleIdentifier) {
        return this.setAttribute("org.eclipse.jdt.junit.CONTAINER", handleIdentifier);
    }

    public JUnitLaunchDescription setMainType(String mainType) {
        return this.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
    }

    public JUnitLaunchDescription setTestKind(String testKindId) {
        return this.setAttribute("org.eclipse.jdt.junit.TEST_KIND", testKindId);
    }

    public JUnitLaunchDescription setTestName(String testName) {
        return this.setAttribute("org.eclipse.jdt.junit.TESTNAME", testName);
    }

    public String toString() {
        return "JUnitLaunchDescription(" + this.fName + ")";
    }

    protected String getProjectName() {
        IJavaProject project = this.getProject();
        return project == null ? null : project.getElementName();
    }

    boolean attributesMatch(ILaunchConfiguration config) throws CoreException {
        int i = 0;
        while (i < ATTRIBUTES_THAT_MUST_MATCH.length) {
            if (!this.configurationMatches(ATTRIBUTES_THAT_MUST_MATCH[i], config)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean configurationMatches(String attributeName, ILaunchConfiguration config) throws CoreException {
        return config.getAttribute(attributeName, "").equals(this.getAttribute(attributeName));
    }

    void setMainType(IType type) {
        this.setMainType(JavaModelUtil.getFullyQualifiedName((IType)type));
    }

    private boolean areEqual(Object thing, Object otherThing) {
        if (thing == null) {
            return otherThing == null;
        }
        return thing.equals(otherThing);
    }

    public IJavaProject getProject() {
        return this.fElement == null ? null : this.fElement.getJavaProject();
    }

    private JUnitLaunchDescription setAttribute(String attr, String value) {
        this.fAttributes.put(attr, value);
        return this;
    }
}

