/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.buildpath.JUnitContainerInitializer;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.osgi.framework.Bundle;

public class BuildPathSupport {
    public static final String JUNIT3_PLUGIN_ID = "org.junit";
    public static final String JUNIT4_PLUGIN_ID = "org.junit4";

    public static IPath getBundleLocation(String bundleName) {
        Bundle bundle = JUnitPlugin.getDefault().getBundle(bundleName);
        if (bundle == null) {
            return null;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = new File(local.getPath()).getAbsolutePath();
        return Path.fromOSString((String)fullPath);
    }

    public static IPath getSourceLocation(String bundleName) {
        Bundle bundle = JUnitPlugin.getDefault().getBundle(bundleName);
        if (bundle == null) {
            return null;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            return null;
        }
        bundle = JUnitPlugin.getDefault().getBundle("org.eclipse.jdt.source");
        if (bundle == null) {
            return null;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = String.valueOf(new File(local.getPath()).getAbsolutePath()) + File.separator + "src" + File.separator + bundleName + "_" + version;
        return Path.fromOSString((String)fullPath);
    }

    public static IClasspathEntry getJUnit3ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitContainerInitializer.JUNIT3_PATH);
    }

    public static IClasspathEntry getJUnit4ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitContainerInitializer.JUNIT4_PATH);
    }

    public static IClasspathEntry getJUnit3LibraryEntry() {
        IPath bundleBase = BuildPathSupport.getBundleLocation(JUNIT3_PLUGIN_ID);
        if (bundleBase != null) {
            IPath jarLocation = bundleBase.append("junit.jar");
            IPath sourceBase = BuildPathSupport.getSourceLocation(JUNIT3_PLUGIN_ID);
            IPath srcLocation = sourceBase != null ? sourceBase.append("junitsrc.zip") : null;
            return JavaCore.newLibraryEntry((IPath)jarLocation, (IPath)srcLocation, null);
        }
        return null;
    }

    public static IClasspathEntry getJUnit4LibraryEntry() {
        IPath bundleBase = BuildPathSupport.getBundleLocation(JUNIT4_PLUGIN_ID);
        if (bundleBase != null) {
            IPath jarLocation = bundleBase.append("junit-4.1.jar");
            IPath sourceBase = BuildPathSupport.getSourceLocation(JUNIT4_PLUGIN_ID);
            IPath srcLocation = sourceBase != null ? sourceBase.append("junit-4.1src.zip") : null;
            return JavaCore.newLibraryEntry((IPath)jarLocation, (IPath)srcLocation, null);
        }
        return null;
    }
}

