/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.launcher;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import org.eclipse.core.launcher.Main;

public class WebStartMain
extends Main {
    private static final String PROP_WEBSTART_AUTOMATIC_INSTALLATION = "eclipse.webstart.automaticInstallation";
    private static final String DEFAULT_OSGI_BUNDLES = "org.eclipse.equinox.common@2:start, org.eclipse.core.runtime@start";
    private static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private static final String PROP_WEBSTART_PRECISE_BUNDLEID = "eclipse.webstart.preciseBundleId";
    private static final String JAVA_6 = "1.6";
    private URL[] allJars = null;
    private Map bundleList = null;
    private Map bundleStartInfo = null;
    private boolean preciseIdExtraction = false;

    public static void main(String[] args) {
        System.setSecurityManager(null);
        int result = new WebStartMain().run(args);
        System.exit(result);
    }

    private void setDefaultBundles() {
        if (System.getProperty(PROP_OSGI_BUNDLES) != null) {
            return;
        }
        System.getProperties().put(PROP_OSGI_BUNDLES, DEFAULT_OSGI_BUNDLES);
    }

    protected void basicRun(String[] args) throws Exception {
        this.preciseIdExtraction = Boolean.getBoolean(PROP_WEBSTART_PRECISE_BUNDLEID);
        if (this.checkVersion(System.getProperty("java.version"), JAVA_6)) {
            this.preciseIdExtraction = true;
        }
        this.setDefaultBundles();
        this.addOSGiBundle();
        this.initializeBundleListStructure();
        this.mapURLsToBundleList();
        String fwkURL = this.searchFor(this.framework, null);
        System.getProperties().put("osgi.framework", fwkURL);
        super.basicRun(args);
    }

    private void addOSGiBundle() {
        System.getProperties().put(PROP_OSGI_BUNDLES, String.valueOf(System.getProperty(PROP_OSGI_BUNDLES)) + ',' + this.framework);
    }

    protected URL[] getBootPath(String base) throws IOException {
        URL[] result = super.getBootPath(base);
        this.buildOSGiBundleList();
        this.cleanup();
        return result;
    }

    private void cleanup() {
        this.allJars = null;
        this.bundleList = null;
        this.bundleStartInfo = null;
    }

    protected String searchFor(String target, String start) {
        ArrayList matches = (ArrayList)this.bundleList.get(target);
        int numberOfURLs = matches.size();
        if (numberOfURLs == 1) {
            return this.extractInnerURL((URL)matches.get(0));
        }
        if (numberOfURLs == 0) {
            return null;
        }
        String[] urls = this.urlsToString(matches.toArray(new URL[matches.size()]));
        int idx = this.findMax(urls);
        if (idx == -1) {
            return null;
        }
        return this.extractInnerURL((URL)matches.get(idx));
    }

    private String[] urlsToString(URL[] urls) {
        String[] result = new String[urls.length];
        int i = 0;
        while (i < result.length) {
            result[i] = urls[i].toExternalForm();
            ++i;
        }
        return result;
    }

    private URL[] getAllJars() {
        if (this.allJars != null) {
            return this.allJars;
        }
        ArrayList<URL> collector = new ArrayList<URL>();
        try {
            Enumeration<URL> resources = WebStartMain.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                collector.add(resources.nextElement());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.allJars = new URL[collector.size()];
        collector.toArray(this.allJars);
        if (this.debug) {
            this.printArray("Jars found on the webstart path:\n", this.allJars);
        }
        return this.allJars;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractInnerURL(URL url) {
        try {
            URLConnection connection = null;
            try {
                connection = url.openConnection();
                if (!(connection instanceof JarURLConnection)) return url.toExternalForm();
                String string = "file:" + ((JarURLConnection)connection).getJarFile().getName();
                return string;
            }
            finally {
                if (connection != null) {
                    connection.getInputStream().close();
                }
            }
        }
        catch (IOException iOException) {}
        return url.toExternalForm();
    }

    private void printArray(String header, Object[] values) {
        System.err.println(header);
        int i = 0;
        while (i < values.length) {
            System.err.println("\t" + values[i].toString());
            ++i;
        }
    }

    private void initializeBundleListStructure() {
        String prop = System.getProperty(PROP_OSGI_BUNDLES);
        if (prop == null || prop.trim().equals("")) {
            this.bundleList = new HashMap(0);
            return;
        }
        this.bundleList = new HashMap(10);
        this.bundleStartInfo = new HashMap(10);
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token;
            String bundleId = token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            int startLevelSeparator = token.lastIndexOf(64);
            if (startLevelSeparator != -1) {
                bundleId = token.substring(0, startLevelSeparator);
                this.bundleStartInfo.put(bundleId, token.substring(startLevelSeparator));
            }
            this.bundleList.put(bundleId, new ArrayList(1));
        }
    }

    private void mapURLsToBundleList() {
        URL[] allJars = this.getAllJars();
        int i = 0;
        while (i < allJars.length) {
            String bsn;
            Object[] bundleInfo = this.extractBundleId(allJars[i]);
            if (bundleInfo != null && (bsn = (String)bundleInfo[0]) != null) {
                String version = (String)bundleInfo[1];
                ArrayList bundleURLs = null;
                if (bsn != null && version != null) {
                    bundleURLs = (ArrayList)this.bundleList.get(String.valueOf(bsn) + '_' + version);
                }
                if (bundleURLs != null || (bundleURLs = (ArrayList)this.bundleList.get(bsn)) != null) {
                    bundleURLs.add(allJars[i]);
                    allJars[i] = null;
                }
            }
            ++i;
        }
    }

    private Object[] extractBundleId(URL url) {
        if (this.preciseIdExtraction) {
            return this.extractBundleIdFromManifest(url);
        }
        return this.extractBundleIdFromBundleURL(url);
    }

    private Object[] extractBundleIdFromManifest(URL url) {
        String symbolicNameString;
        Manifest mf;
        block4: {
            try {
                mf = new Manifest(url.openStream());
                symbolicNameString = mf.getMainAttributes().getValue("Bundle-SymbolicName");
                if (symbolicNameString != null) break block4;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        String bundleVersion = mf.getMainAttributes().getValue("Bundle-Version");
        int pos = symbolicNameString.lastIndexOf(59);
        if (pos != -1) {
            return new Object[]{symbolicNameString.substring(0, pos), bundleVersion};
        }
        return new Object[]{symbolicNameString, bundleVersion};
    }

    private Object[] extractBundleIdFromBundleURL(URL urls) {
        String url = urls.toExternalForm();
        int lastBang = url.lastIndexOf(33);
        if (lastBang == -1) {
            return null;
        }
        boolean jarSuffix = url.regionMatches(true, lastBang - 4, ".jar", 0, 4);
        int bundleIdStart = url.lastIndexOf(47, lastBang);
        String fileName = url.substring(bundleIdStart + 3, lastBang - (jarSuffix ? 4 : 0));
        String bsn = null;
        String version = null;
        int underScore = fileName.indexOf(95);
        while (underScore >= 0) {
            bsn = fileName.substring(0, underScore);
            version = fileName.substring(underScore + 1);
            if (this.isValidVersion(version)) break;
            underScore = fileName.indexOf(95, underScore + 1);
        }
        return new Object[]{bsn, version};
    }

    private void buildOSGiBundleList() {
        this.bundleList.remove(this.framework);
        URL[] jarsOnClasspath = this.getAllJars();
        StringBuffer finalBundleList = new StringBuffer(jarsOnClasspath.length * 25);
        Collection allSelectedBundles = this.bundleList.entrySet();
        for (Map.Entry entry : allSelectedBundles) {
            String[] urls;
            int idx;
            ArrayList matches = (ArrayList)entry.getValue();
            int numberOfURLs = matches.size();
            String startInfo = (String)this.bundleStartInfo.get(entry.getKey());
            if (startInfo == null) {
                startInfo = "";
            }
            if (numberOfURLs == 1) {
                finalBundleList.append("reference:").append(this.extractInnerURL((URL)matches.get(0))).append(startInfo).append(',');
                continue;
            }
            if (numberOfURLs == 0 || (idx = this.findMax(urls = this.urlsToString(matches.toArray(new URL[matches.size()])))) == -1) continue;
            finalBundleList.append(this.extractInnerURL((URL)matches.get(idx)));
        }
        if (!Boolean.FALSE.toString().equalsIgnoreCase(System.getProperties().getProperty(PROP_WEBSTART_AUTOMATIC_INSTALLATION))) {
            int i = 0;
            while (i < jarsOnClasspath.length) {
                if (jarsOnClasspath[i] != null) {
                    finalBundleList.append("reference:").append(this.extractInnerURL(jarsOnClasspath[i])).append(',');
                }
                ++i;
            }
        }
        System.getProperties().put(PROP_OSGI_BUNDLES, finalBundleList.toString());
        if (this.debug) {
            this.log(finalBundleList.toString());
        }
    }

    private boolean isValidVersion(String version) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        try {
            StringTokenizer st = new StringTokenizer(version, ".", true);
            major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    micro = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        qualifier = st.nextToken();
                        if (st.hasMoreTokens()) {
                            return false;
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return this.isValidVersionSegment(major, minor, micro, qualifier);
    }

    private boolean isValidVersionSegment(int major, int minor, int micro, String qualifier) {
        if (major < 0) {
            return false;
        }
        if (minor < 0) {
            return false;
        }
        int length = qualifier.length();
        int i = 0;
        while (i < length) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-".indexOf(qualifier.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

