/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AssembleConfigScriptGenerator;
import org.eclipse.pde.internal.build.AssembleScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.packager.PackageConfigScriptGenerator;

public class PackageScriptGenerator
extends AssembleScriptGenerator {
    private String packagingPropertiesLocation;
    private boolean backwardCompatibleName = false;

    public PackageScriptGenerator(String directory, AssemblyInformation assemblageInformation, String featureId) {
        super(directory, assemblageInformation, featureId);
    }

    protected void printProjectDeclaration() {
        this.script.printProjectDeclaration("Package all config of " + this.featureId, "main", null);
    }

    protected AssembleConfigScriptGenerator getConfigScriptGenerator() {
        return new PackageConfigScriptGenerator();
    }

    protected String getScriptName() {
        if (this.backwardCompatibleName) {
            return "package.all.xml";
        }
        return "package." + (this.featureId.equals("") ? "" : String.valueOf(this.featureId) + '.') + "all.xml";
    }

    public void setPropertyFile(String propertyFile) {
        this.packagingPropertiesLocation = propertyFile;
    }

    protected Collection[] getConfigInfos(Config aConfig) {
        return new Collection[]{this.assemblageInformation.getBinaryPlugins(aConfig), this.assemblageInformation.getBinaryFeatures(aConfig), this.assemblageInformation.getFeatures(aConfig), new HashSet(0)};
    }

    protected void basicGenerateAssembleConfigFileTargetCall(Config aConfig, Collection binaryPlugins, Collection binaryFeatures, Collection allFeatures, Collection rootFiles) throws CoreException {
        this.configScriptGenerator.initialize(this.directory, this.featureId, aConfig, binaryPlugins, binaryFeatures, allFeatures, rootFiles);
        ((PackageConfigScriptGenerator)this.configScriptGenerator).setPackagingPropertiesLocation(this.packagingPropertiesLocation);
        this.configScriptGenerator.setArchiveFormat((String)this.archivesFormat.get(aConfig));
        this.configScriptGenerator.setGroupConfigs(this.groupConfigs);
        PackageScriptGenerator.setForceUpdateJar(forceUpdateJarFormat);
        this.configScriptGenerator.setBuildSiteFactory(this.siteFactory);
        this.configScriptGenerator.generate();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("assembleScriptName", String.valueOf(this.configScriptGenerator.getTargetName()) + ".xml");
        this.script.printAntTask(Utils.getPropertyFormat("customTargets"), null, this.computeBackwardCompatibleName(aConfig), null, null, params);
    }

    public void setBackwardCompatibleName(boolean value) {
        this.backwardCompatibleName = value;
    }

    private String computeBackwardCompatibleName(Config configInfo) {
        if (this.backwardCompatibleName) {
            return "assemble" + (configInfo.equals(Config.genericConfig()) ? "" : String.valueOf('.') + configInfo.toStringReplacingAny(".", "ANY") + (this.backwardCompatibleName ? ".xml" : ""));
        }
        return "assemble" + (this.featureId.equals("") ? "" : String.valueOf('.') + this.featureId) + (configInfo.equals(Config.genericConfig()) ? "" : String.valueOf('.') + configInfo.toStringReplacingAny(".", "ANY") + (this.backwardCompatibleName ? ".xml" : ""));
    }
}

