/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.env.BinaryFileOutputStream;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;

public class EncodedFileOutputStream
extends BinaryFileOutputStream {
    private final String _charsetName;

    public EncodedFileOutputStream(IFile file, BuildEnv env, String charsetName) {
        super(file, env);
        this._charsetName = charsetName;
    }

    public void close() throws IOException {
        super.close();
        if (this._charsetName != null) {
            try {
                this._file.setCharset(this._charsetName, null);
            }
            catch (CoreException ce) {
                IOException ioe = new IOException("Could not set charset: " + this._charsetName);
                ioe.initCause(ce);
                throw ioe;
            }
        }
    }
}

