/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDownload;
import org.eclipse.swt.internal.mozilla.nsIHelperAppLauncher;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsIProgressDialog;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.internal.mozilla.nsIWebProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class Download {
    XPCOMObject supports;
    XPCOMObject download;
    XPCOMObject progressDialog;
    XPCOMObject webProgressListener;
    nsIHelperAppLauncher helperAppLauncher;
    int refCount = 0;
    Shell shell;
    Label status;
    Button cancel;

    public Download() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public long method0(long[] args) {
                return Download.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Download.this.AddRef();
            }

            public long method2(long[] args) {
                return Download.this.Release();
            }
        };
        int[] nArray2 = new int[16];
        nArray2[0] = 2;
        nArray2[3] = 7;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 1;
        nArray2[10] = 2;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = 1;
        nArray2[14] = 1;
        nArray2[15] = 1;
        this.download = new XPCOMObject(nArray2){

            public long method0(long[] args) {
                return Download.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Download.this.AddRef();
            }

            public long method2(long[] args) {
                return Download.this.Release();
            }

            public long method3(long[] args) {
                return Download.this.Init(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            public long method4(long[] args) {
                return Download.this.GetSource(args[0]);
            }

            public long method5(long[] args) {
                return Download.this.GetTarget(args[0]);
            }

            public long method6(long[] args) {
                return Download.this.GetPersist(args[0]);
            }

            public long method7(long[] args) {
                return Download.this.GetPercentComplete(args[0]);
            }

            public long method8(long[] args) {
                return Download.this.GetDisplayName(args[0]);
            }

            public long method9(long[] args) {
                return Download.this.SetDisplayName(args[0]);
            }

            public long method10(long[] args) {
                return Download.this.GetStartTime(args[0]);
            }

            public long method11(long[] args) {
                return Download.this.GetMIMEInfo(args[0]);
            }

            public long method12(long[] args) {
                return Download.this.GetListener(args[0]);
            }

            public long method13(long[] args) {
                return Download.this.SetListener(args[0]);
            }

            public long method14(long[] args) {
                return Download.this.GetObserver(args[0]);
            }

            public long method15(long[] args) {
                return Download.this.SetObserver(args[0]);
            }
        };
        int[] nArray3 = new int[21];
        nArray3[0] = 2;
        nArray3[3] = 7;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[8] = 1;
        nArray3[9] = 1;
        nArray3[10] = 2;
        nArray3[11] = 1;
        nArray3[12] = 1;
        nArray3[13] = 1;
        nArray3[14] = 1;
        nArray3[15] = 1;
        nArray3[16] = 1;
        nArray3[17] = 1;
        nArray3[18] = 1;
        nArray3[19] = 1;
        nArray3[20] = 1;
        this.progressDialog = new XPCOMObject(nArray3){

            public long method0(long[] args) {
                return Download.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Download.this.AddRef();
            }

            public long method2(long[] args) {
                return Download.this.Release();
            }

            public long method3(long[] args) {
                return Download.this.Init(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            public long method4(long[] args) {
                return Download.this.GetSource(args[0]);
            }

            public long method5(long[] args) {
                return Download.this.GetTarget(args[0]);
            }

            public long method6(long[] args) {
                return Download.this.GetPersist(args[0]);
            }

            public long method7(long[] args) {
                return Download.this.GetPercentComplete(args[0]);
            }

            public long method8(long[] args) {
                return Download.this.GetDisplayName(args[0]);
            }

            public long method9(long[] args) {
                return Download.this.SetDisplayName(args[0]);
            }

            public long method10(long[] args) {
                return Download.this.GetStartTime(args[0]);
            }

            public long method11(long[] args) {
                return Download.this.GetMIMEInfo(args[0]);
            }

            public long method12(long[] args) {
                return Download.this.GetListener(args[0]);
            }

            public long method13(long[] args) {
                return Download.this.SetListener(args[0]);
            }

            public long method14(long[] args) {
                return Download.this.GetObserver(args[0]);
            }

            public long method15(long[] args) {
                return Download.this.SetObserver(args[0]);
            }

            public long method16(long[] args) {
                return Download.this.Open(args[0]);
            }

            public long method17(long[] args) {
                return Download.this.GetCancelDownloadOnClose(args[0]);
            }

            public long method18(long[] args) {
                return Download.this.SetCancelDownloadOnClose(args[0]);
            }

            public long method19(long[] args) {
                return Download.this.GetDialog(args[0]);
            }

            public long method20(long[] args) {
                return Download.this.SetDialog(args[0]);
            }
        };
        int[] nArray4 = new int[8];
        nArray4[0] = 2;
        nArray4[3] = 4;
        nArray4[4] = 6;
        nArray4[5] = 3;
        nArray4[6] = 4;
        nArray4[7] = 3;
        this.webProgressListener = new XPCOMObject(nArray4){

            public long method0(long[] args) {
                return Download.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Download.this.AddRef();
            }

            public long method2(long[] args) {
                return Download.this.Release();
            }

            public long method3(long[] args) {
                return Download.this.OnStateChange(args[0], args[1], args[2], args[3]);
            }

            public long method4(long[] args) {
                return Download.this.OnProgressChange(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            public long method5(long[] args) {
                return Download.this.OnLocationChange(args[0], args[1], args[2]);
            }

            public long method6(long[] args) {
                return Download.this.OnStatusChange(args[0], args[1], args[2], args[3]);
            }

            public long method7(long[] args) {
                return Download.this.OnSecurityChange(args[0], args[1], args[2]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.download != null) {
            this.download.dispose();
            this.download = null;
        }
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
            this.progressDialog = null;
        }
        if (this.webProgressListener != null) {
            this.webProgressListener.dispose();
            this.webProgressListener = null;
        }
    }

    long getAddress() {
        return this.progressDialog.getAddress();
    }

    long QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262L;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.supports.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIDownload.NS_IDOWNLOAD_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.download.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIProgressDialog.NS_IPROGRESSDIALOG_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.progressDialog.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.webProgressListener.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(ppvObject, new long[1], OS.PTR_SIZEOF);
        return -2147467262L;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    public long Init(long aSource, long aTarget, long aDisplayName, long aMIMEInfo, long startTime1, long startTime2, long aPersist) {
        nsIURI source = new nsIURI(aSource);
        long aSpec = XPCOM.nsEmbedCString_new();
        source.GetHost(aSpec);
        int length = XPCOM.nsEmbedCString_Length(aSpec);
        long buffer = XPCOM.nsEmbedCString_get(aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aSpec);
        String url = new String(dest);
        nsILocalFile target = new nsILocalFile(aTarget);
        long aNativeTarget = XPCOM.nsEmbedCString_new();
        target.GetNativeLeafName(aNativeTarget);
        length = XPCOM.nsEmbedCString_Length(aNativeTarget);
        buffer = XPCOM.nsEmbedCString_get(aNativeTarget);
        dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aNativeTarget);
        String file = new String(dest);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == Download.this.cancel) {
                    Download.this.shell.close();
                }
                if (Download.this.helperAppLauncher != null) {
                    Download.this.helperAppLauncher.Cancel();
                    Download.this.helperAppLauncher.Release();
                }
                Download.this.shell = null;
                Download.this.helperAppLauncher = null;
            }
        };
        this.shell = new Shell(2144);
        String msg = Compatibility.getMessage("SWT_Download_File", new Object[]{file});
        this.shell.setText(msg);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        this.shell.setLayout(gridLayout);
        msg = Compatibility.getMessage("SWT_Download_Location", new Object[]{file, url});
        new Label(this.shell, 64).setText(msg);
        this.status = new Label(this.shell, 64);
        msg = Compatibility.getMessage("SWT_Download_Started");
        this.status.setText(msg);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.status.setLayoutData(data);
        this.cancel = new Button(this.shell, 8);
        this.cancel.setText(SWT.getMessage("SWT_Cancel"));
        data = new GridData();
        data.horizontalAlignment = 2;
        this.cancel.setLayoutData(data);
        this.cancel.addListener(13, listener);
        this.shell.addListener(21, listener);
        this.shell.pack();
        this.shell.open();
        return 0L;
    }

    public long GetSource(long aSource) {
        return -2147467263L;
    }

    public long GetTarget(long aTarget) {
        return -2147467263L;
    }

    public long GetPersist(long aPersist) {
        return -2147467263L;
    }

    public long GetPercentComplete(long aPercentComplete) {
        return -2147467263L;
    }

    public long GetDisplayName(long aDisplayName) {
        return -2147467263L;
    }

    public long SetDisplayName(long aDisplayName) {
        return -2147467263L;
    }

    public long GetStartTime(long aStartTime) {
        return -2147467263L;
    }

    public long GetMIMEInfo(long aMIMEInfo) {
        return -2147467263L;
    }

    public long GetListener(long aListener) {
        return -2147467263L;
    }

    public long SetListener(long aListener) {
        return -2147467263L;
    }

    public long GetObserver(long aObserver) {
        return -2147467263L;
    }

    public long SetObserver(long aObserver) {
        if (aObserver != 0L) {
            nsISupports supports = new nsISupports(aObserver);
            long[] result = new long[1];
            int rc = supports.QueryInterface(nsIHelperAppLauncher.NS_IHELPERAPPLAUNCHER_IID, result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            this.helperAppLauncher = new nsIHelperAppLauncher(result[0]);
        }
        return 0L;
    }

    public long Open(long aParent) {
        return -2147467263L;
    }

    public long GetCancelDownloadOnClose(long aCancelDownloadOnClose) {
        return -2147467263L;
    }

    public long SetCancelDownloadOnClose(long aCancelDownloadOnClose) {
        return -2147467263L;
    }

    public long GetDialog(long aDialog) {
        return -2147467263L;
    }

    public long SetDialog(long aDialog) {
        return -2147467263L;
    }

    long OnStateChange(long aWebProgress, long aRequest, long aStateFlags, long aStatus) {
        if ((aStateFlags & 0x10L) != 0L) {
            if (this.helperAppLauncher != null) {
                this.helperAppLauncher.Release();
            }
            this.helperAppLauncher = null;
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.dispose();
            }
            this.shell = null;
        }
        return 0L;
    }

    long OnProgressChange(long aWebProgress, long aRequest, long aCurSelfProgress, long aMaxSelfProgress, long aCurTotalProgress, long aMaxTotalProgress) {
        int currentBytes = (int)aCurTotalProgress / 1024;
        int totalBytes = (int)aMaxTotalProgress / 1024;
        if (this.shell != null & !this.shell.isDisposed()) {
            Object[] arguments = new Object[]{new Integer(currentBytes), new Integer(totalBytes)};
            String statusMsg = Compatibility.getMessage("SWT_Download_Status", arguments);
            this.status.setText(statusMsg);
            this.shell.layout(true);
            this.shell.getDisplay().update();
        }
        return 0L;
    }

    long OnLocationChange(long aWebProgress, long aRequest, long aLocation) {
        return 0L;
    }

    long OnStatusChange(long aWebProgress, long aRequest, long aStatus, long aMessage) {
        return 0L;
    }

    long OnSecurityChange(long aWebProgress, long aRequest, long state) {
        return 0L;
    }
}

