/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.ThreadEventHandler;

public class StackFrameEventHandler
extends DebugEventHandler {
    ThreadEventHandler fThreadHandler = null;

    public StackFrameEventHandler(AbstractModelProxy proxy, ThreadEventHandler threadHandler) {
        super(proxy);
        this.fThreadHandler = threadHandler;
    }

    protected boolean handlesEvent(DebugEvent event) {
        return event.getSource() instanceof IStackFrame;
    }

    protected void handleChange(DebugEvent event) {
        IStackFrame frame = (IStackFrame)event.getSource();
        ModelDelta delta = this.fThreadHandler.buildRootDelta();
        delta = this.fThreadHandler.addPathToThread(delta, frame.getThread());
        delta = delta.addNode(frame.getThread(), 0);
        int flags = 0;
        if (event.getDetail() == 512) {
            flags |= 0x400;
        } else if (event.getDetail() == 256) {
            flags |= 0x800;
        }
        delta = delta.addNode(frame, flags);
        this.fireDelta(delta);
    }
}

