/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeContribution;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class LaunchGroupFilter
extends ViewerFilter {
    private ILaunchGroup fGroup;

    public LaunchGroupFilter(ILaunchGroup groupExtension) {
        this.fGroup = groupExtension;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ILaunchConfigurationType type = null;
        ILaunchConfiguration config = null;
        if (parentElement instanceof ILaunchConfigurationType) {
            type = (ILaunchConfigurationType)parentElement;
        }
        if (element instanceof ILaunchConfigurationType) {
            type = (ILaunchConfigurationType)element;
        }
        if (element instanceof ILaunchConfiguration) {
            config = (ILaunchConfiguration)element;
            try {
                type = config.getType();
            }
            catch (CoreException coreException) {}
        }
        boolean priv = false;
        if (config != null) {
            try {
                priv = config.getAttribute(IDebugUIConstants.ATTR_PRIVATE, false);
            }
            catch (CoreException coreException) {}
        }
        if (type != null) {
            return !priv && type.supportsMode(this.fGroup.getMode()) && this.equalCategories(type.getCategory(), this.fGroup.getCategory()) && !WorkbenchActivityHelper.filterItem((Object)new LaunchConfigurationTypeContribution(type));
        }
        return false;
    }

    private boolean equalCategories(String c1, String c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        return c1.equals(c2);
    }
}

