/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public class ConnectionThreadManager {
    private static final String CONNECT_TIMEOUT = "60000";
    private static final String READ_TIMEOUT = "60000";
    private static final int MAX_COUNT = 9;
    private List threads = new ArrayList(9);

    public ConnectionThreadManager() {
        this.setIfNotDefaultProperty("sun.net.client.defaultConnectTimeout", "60000");
        this.setIfNotDefaultProperty("sun.net.client.defaultReadTimeout", "60000");
    }

    private void setIfNotDefaultProperty(String key, String value) {
        String oldValue = System.getProperty(key);
        if (oldValue == null || oldValue.equals("-1")) {
            System.setProperty(key, value);
        }
    }

    public Thread getConnectionThread(StreamRunnable runnable) throws CoreException {
        this.validateExistingThreads();
        Thread t = new Thread(runnable);
        t.setDaemon(true);
        this.threads.add(t);
        return t;
    }

    private void validateExistingThreads() throws CoreException {
        if (this.threads == null || this.threads.size() == 0) {
            return;
        }
        int aliveCount = this.purgeTerminatedThreads();
        if (aliveCount > 9) {
            ArrayList<Status> children = new ArrayList<Status>();
            String pluginId = UpdateCore.getPlugin().getBundle().getSymbolicName();
            int i = 0;
            while (i < this.threads.size()) {
                ConnectionThread t = (ConnectionThread)this.threads.get(i);
                String url = t.getRunnable().getURL().toString();
                Status status = new Status(4, pluginId, 0, NLS.bind((String)Messages.ConnectionThreadManager_unresponsiveURL, (Object[])new String[]{url}), null);
                children.add(status);
                ++i;
            }
            MultiStatus parentStatus = new MultiStatus(pluginId, 0, children.toArray(new IStatus[children.size()]), Messages.ConnectionThreadManager_tooManyConnections, null);
            throw new CoreException((IStatus)parentStatus);
        }
    }

    private int purgeTerminatedThreads() {
        if (this.threads.size() == 0) {
            return 0;
        }
        int aliveCount = 0;
        Object[] array = this.threads.toArray();
        int i = 0;
        while (i < array.length) {
            Thread t = (Thread)array[i];
            if (!t.isAlive()) {
                this.threads.remove(t);
            } else {
                ++aliveCount;
            }
            ++i;
        }
        return aliveCount;
    }

    public void shutdown() {
        this.threads.clear();
    }

    public static class StreamRunnable
    implements Runnable {
        private URLConnection urlConnection;
        private IOException ioException;
        private Exception exception;
        private InputStream is;
        private boolean disconnected;

        public StreamRunnable(URLConnection urlConnection) {
            this.urlConnection = urlConnection;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public URL getURL() {
            return this.urlConnection.getURL();
        }

        public IOException getIOException() {
            return this.ioException;
        }

        public Exception getException() {
            return this.exception;
        }

        public void disconnect() {
            if (this.urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.urlConnection).disconnect();
            }
            this.disconnected = true;
        }

        public void run() {
            block8: {
                try {
                    this.is = this.urlConnection.getInputStream();
                    if (!this.disconnected || this.is == null) break block8;
                    try {
                        try {
                            this.is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    finally {
                        this.is = null;
                    }
                }
                catch (IOException e) {
                    this.ioException = e;
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        }
    }

    class ConnectionThread
    extends Thread {
        private StreamRunnable runnable;

        public ConnectionThread(StreamRunnable runnable) {
            super((Runnable)runnable, "update-connection");
            this.runnable = runnable;
        }

        public StreamRunnable getRunnable() {
            return this.runnable;
        }
    }
}

