/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Vector;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.logging.Logger;

public class JspReader {
    protected Mark current = null;
    String master = null;
    Vector sourceFiles = new Vector();
    int currFileId = 0;
    int size = 0;
    private JspCompilationContext context;
    private ErrorDispatcher err;
    boolean singleFile = false;
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "JspReader");

    public String getFile(int fileid) {
        return (String)this.sourceFiles.elementAt(fileid);
    }

    protected int registerSourceFile(String file) {
        if (this.sourceFiles.contains(file)) {
            return -1;
        }
        this.sourceFiles.addElement(file);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    protected int unregisterSourceFile(String file) {
        if (!this.sourceFiles.contains(file)) {
            return -1;
        }
        this.sourceFiles.removeElement(file);
        --this.size;
        return this.sourceFiles.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushFile2(String file, String encoding, InputStreamReader reader) throws JasperException, FileNotFoundException {
        block11: {
            String longName = file;
            int fileid = this.registerSourceFile(longName);
            if (fileid == -1) {
                this.err.jspError("jsp.error.file.already.registered", file);
            }
            this.currFileId = fileid;
            CharArrayWriter caw = new CharArrayWriter();
            char[] buf = new char[1024];
            int i = 0;
            while ((i = reader.read(buf)) != -1) {
                caw.write(buf, 0, i);
            }
            caw.close();
            if (this.current == null) {
                this.current = new Mark(this, caw.toCharArray(), fileid, this.getFile(fileid), this.master, encoding);
                break block11;
            }
            this.current.pushStream(caw.toCharArray(), fileid, this.getFile(fileid), longName, encoding);
        }
        Object var10_10 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (Exception any) {}
        return;
        {
            catch (Throwable ex) {
                this.loghelper.log("Exception parsing file ", ex);
                this.popFile();
                this.err.jspError("jsp.error.file.cannot.read", "ze file");
                Object var10_11 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (Exception any) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception any) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean popFile() throws JasperException {
        boolean result;
        if (this.current == null) {
            return false;
        }
        if (this.currFileId < 0) {
            this.err.jspError("jsp.error.no.more.content");
        }
        String fName = this.getFile(this.currFileId);
        this.currFileId = this.unregisterSourceFile(fName);
        if (this.currFileId < -1) {
            this.err.jspError("jsp.error.file.not.registered", fName);
        }
        if (result = this.current.popStream()) {
            this.master = this.current.baseDir;
        }
        return result;
    }

    protected JspReader(JspCompilationContext ctx, String file, String encoding, InputStreamReader reader, ErrorDispatcher err) throws JasperException, FileNotFoundException {
        this.context = ctx;
        this.err = err;
        this.pushFile2(file, encoding, reader);
    }

    public boolean hasMoreInput() throws JasperException {
        if (this.current.cursor >= this.current.stream.length) {
            if (this.singleFile) {
                return false;
            }
            while (this.popFile()) {
                if (this.current.cursor >= this.current.stream.length) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public int nextChar() throws JasperException {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char ch = this.current.stream[this.current.cursor];
        ++this.current.cursor;
        if (ch == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return ch;
    }

    char[] nextContent() {
        char ch;
        int cur_cursor = this.current.cursor;
        int len = this.current.stream.length;
        if (this.peekChar() == 10) {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        while (++this.current.cursor < len && (ch = this.current.stream[this.current.cursor]) != '<') {
            if (ch == '\n') {
                ++this.current.line;
                this.current.col = 0;
                continue;
            }
            ++this.current.col;
        }
        len = this.current.cursor - cur_cursor;
        char[] content = new char[len];
        System.arraycopy(this.current.stream, cur_cursor, content, 0, len);
        return content;
    }

    char[] getText(Mark start, Mark stop) throws JasperException {
        Mark oldstart = this.mark();
        this.reset(start);
        CharArrayWriter caw = new CharArrayWriter();
        while (!stop.equals(this.mark())) {
            caw.write(this.nextChar());
        }
        caw.close();
        this.reset(oldstart);
        return caw.toCharArray();
    }

    public int peekChar() {
        return this.current.stream[this.current.cursor];
    }

    public Mark mark() {
        return new Mark(this.current);
    }

    public void reset(Mark mark) {
        this.current = new Mark(mark);
    }

    public boolean matchesIgnoreCase(String string) throws JasperException {
        Mark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if (Character.toLowerCase((char)(ch = this.nextChar())) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        this.reset(mark);
        return true;
    }

    public boolean matches(String string) throws JasperException {
        Mark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if ((char)(ch = this.nextChar()) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        return true;
    }

    public boolean matchesETag(String tagName) throws JasperException {
        Mark mark = this.mark();
        if (!this.matches("</" + tagName)) {
            return false;
        }
        this.skipSpaces();
        if (this.nextChar() == 62) {
            return true;
        }
        this.reset(mark);
        return false;
    }

    public void advance(int n) throws JasperException {
        while (--n >= 0) {
            this.nextChar();
        }
    }

    public int skipSpaces() throws JasperException {
        int i = 0;
        while (this.isSpace()) {
            ++i;
            this.nextChar();
        }
        return i;
    }

    public Mark skipUntil(String limit) throws JasperException {
        Mark ret = null;
        int limlen = limit.length();
        ret = this.mark();
        int ch = this.nextChar();
        while (ch != -1) {
            block4: {
                if (ch == limit.charAt(0)) {
                    Mark restart = this.mark();
                    for (int i = 1; i < limlen; ++i) {
                        if (this.peekChar() != limit.charAt(i)) {
                            this.reset(restart);
                            break block4;
                        }
                        this.nextChar();
                    }
                    return ret;
                }
            }
            ret = this.mark();
            ch = this.nextChar();
        }
        return null;
    }

    public Mark skipUntilIgnoreEsc(String limit) throws JasperException {
        Mark ret = null;
        int limlen = limit.length();
        char prev = 'x';
        ret = this.mark();
        char ch = this.nextChar();
        while (ch != '\uffffffff') {
            block4: {
                if (ch == limit.charAt(0) && prev != '\\') {
                    for (int i = 1; i < limlen; ++i) {
                        if (this.peekChar() == limit.charAt(i)) {
                            this.nextChar();
                            continue;
                        }
                        break block4;
                    }
                    return ret;
                }
            }
            ret = this.mark();
            prev = ch;
            ch = this.nextChar();
        }
        return null;
    }

    public Mark skipUntilETag(String tag) throws JasperException {
        Mark ret = this.skipUntil("</" + tag);
        if (ret != null) {
            this.skipSpaces();
            if (this.nextChar() != 62) {
                ret = null;
            }
        }
        return ret;
    }

    final boolean isSpace() {
        return this.peekChar() <= 32;
    }

    public String parseToken(boolean quoted) throws JasperException {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        stringBuffer.setLength(0);
        int ch = this.peekChar();
        if (quoted) {
            if (ch == 34 || ch == 39) {
                int endQuote = ch == 34 ? 34 : 39;
                ch = this.nextChar();
                ch = this.nextChar();
                while (ch != -1 && ch != endQuote) {
                    if (ch == 92) {
                        ch = this.nextChar();
                    }
                    stringBuffer.append((char)ch);
                    ch = this.nextChar();
                }
                if (ch == -1) {
                    this.err.jspError(this.mark(), "jsp.error.quotes.unterminated");
                }
            } else {
                this.err.jspError(this.mark(), "jsp.error.attr.quoted");
            }
        } else if (!this.isDelimiter()) {
            do {
                if ((ch = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == 62 || this.peekChar() == 37)) {
                    ch = this.nextChar();
                }
                stringBuffer.append((char)ch);
            } while (!this.isDelimiter());
        }
        return stringBuffer.toString();
    }

    private boolean isDelimiter() throws JasperException {
        if (!this.isSpace()) {
            int ch = this.peekChar();
            if (ch == 61 || ch == 62 || ch == 34 || ch == 39 || ch == 47) {
                return true;
            }
            if (ch == 45) {
                Mark mark = this.mark();
                ch = this.nextChar();
                if (ch == 62 || ch == 45 && this.nextChar() == 62) {
                    this.reset(mark);
                    return true;
                }
                this.reset(mark);
                return false;
            }
            return false;
        }
        return true;
    }

    public void setSingleFile(boolean val) {
        this.singleFile = val;
    }
}

