/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.util;

import java.sql.Connection;

import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogProvider;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

/**
 * @author ljulien
 */
public class DatabaseProviderHelper
{
    private static final ConnectionManager connectionManager = RDBCorePlugin.getDefault().getConnectionManager();

    private void setSharedInformation (ConnectionInfo info, Database database, String databaseName)
    {
        if (info.getSharedDatabase() != null)
        {
            info.removeSharedDatabase();
        }
        database.setName (databaseName);
        info.setSharedDatabase(database);
    }
    
    private Database getCatalogDatabase (Connection connection, ConnectionInfo info, String databaseName)
    {
		ICatalogProvider catalogProvider = info.getDatabaseDefinition().getDatabaseCatalogProvider();
		Database database = catalogProvider.getCatalogDatabase(connection);
		connectionManager.setConnectionInfo(database, info);
		setSharedInformation (info, database, databaseName);
		return database;
    }

    public void setDatabase (Connection connection, ConnectionInfo info, String databaseName)
	{
        getCatalogDatabase (connection, info, databaseName);
	}
}
