/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.internal.ui.dialogs.ConnectedServerDialog;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;
import org.eclipse.wst.rdb.server.internal.ui.util.ServerUIDebugOptions;
import org.eclipse.wst.rdb.server.internal.ui.util.logging.Logger;


/**
 * @author ljulien
 */
public class DisconnectServerAction extends AbstractAction
{
	private static ISelection selection;
	
	/**
	 * Will remove all the non-connected servers 
	 * @param servers
	 */
	private List removeNonConnectedServers (List servers)
	{
		for (int i = 0; i < servers.size(); i++)
		{
			IConnectionNode server = (IConnectionNode) servers.get(i);
			if (!server.isConnected())
			{
				servers.remove(i);
				i--;
			}
		}
		return servers;
	}

	/**
	 * Will set the current selection
	 * @param sel
	 */
	protected void setSelection (ISelection sel)
	{
		selection = sel;
	}

	/**
	 * Will return the current selection
	 * @return
	 */
	protected ISelection getSelection ()
	{
		return selection;
	}
	
	private void disconnectServers (IConnectionNode[] nodes)
	{
	    for (int i = 0, n = nodes.length; i < n; i++)
	    {
	        IConnectionNode node = nodes[i];
	        ConnectionInfo info = node.getConnectionInfo();
	        try
            {
	            Connection connection = info.getSharedConnection();
	            if (info.getSharedDatabase() != null)
	            {
	                info.removeSharedDatabase();
	            }
	            if (info.getSharedConnection() != null)
	            {
	                info.removeSharedConnection();
	                connection.close();
	            }
            }
            catch (SQLException e1)
            {
                Logger.log(this, e1, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
            }
	    }
	    if (nodes.length == 1)
	    {
	        IServicesManager.INSTANCE.getServerExplorerContentService().updateSelection(new StructuredSelection (nodes[0]));
	    }
	}
	
	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action)
	{
		try
		{
			List servers = removeNonConnectedServers(getMultipleSelection(IConnectionNode.class));
			if (!servers.isEmpty())
			{
			    disconnectServers ((IConnectionNode []) servers.toArray(new IConnectionNode[servers.size()]));
			}
			else
			{
				ConnectedServerDialog dialog = new ConnectedServerDialog();
				if (dialog.open() == Window.OK)
				{
				    disconnectServers (dialog.getSelectedServers());
				}
			}
		}
		catch (NullSelectionException e)
		{
			Logger.log(this, e, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
		}
	}
}
