/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BP1316
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1316(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document doc;
        if (this.validator.isOneWayResponse(entryContext) || (doc = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else {
            NodeList faultList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            if (faultList == null || faultList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                try {
                    int n = 0;
                    while (n < faultList.getLength()) {
                        Node child = faultList.item(n).getFirstChild();
                        while (child != null) {
                            if (child.getNodeType() == 1 && (child.getLocalName().equalsIgnoreCase("faultcode") || child.getLocalName().equalsIgnoreCase("faultstring") || child.getLocalName().equalsIgnoreCase("faultactor") || child.getLocalName().equalsIgnoreCase("detail")) && child.getNamespaceURI() != null) {
                                throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                            }
                            child = child.getNextSibling();
                        }
                        ++n;
                    }
                }
                catch (AssertionFailException e) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

