/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.server.runner;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class XMLTransformer {
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String HTML_OUTPUT_METHOD = "html";
    private static final String TEXT_MIME_TYPE = "text/plain";
    private static final String TEXT_OUTPUT_METHOD = "text";
    private static final String XML_MIME_TYPE = "text/xml";
    private static final String XSL_OUTPUT_PROPERTY_METHOD = "method";
    private Templates templates = null;
    private String contentType = "text/xml";
    private static final JoinPoint.StaticPart ajc$tjp_0;

    public XMLTransformer(InputStream theStylesheet) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource source = new StreamSource(theStylesheet);
        this.templates = transformerFactory.newTemplates(source);
        String outputMethod = this.templates.getOutputProperties().getProperty(XSL_OUTPUT_PROPERTY_METHOD);
        this.contentType = this.getContentType(outputMethod);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void transform(Reader reader, Writer writer) throws TransformerException {
        Reader reader2 = reader;
        Writer writer2 = writer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)reader2, (Object)writer2);
        XMLTransformer.transform_aroundBody1$advice(this, reader2, writer2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private String getContentType(String theOutputMethod) {
        String contentType = HTML_OUTPUT_METHOD.equals(theOutputMethod) ? HTML_MIME_TYPE : (TEXT_OUTPUT_METHOD.equals(theOutputMethod) ? TEXT_MIME_TYPE : XML_MIME_TYPE);
        return contentType;
    }

    static {
        Factory factory = new Factory("XMLTransformer.java", Class.forName("org.apache.cactus.internal.server.runner.XMLTransformer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-transform-org.apache.cactus.internal.server.runner.XMLTransformer-java.io.Reader:java.io.Writer:-theXml:theWriter:-javax.xml.transform.TransformerException:-void-"), 144);
    }

    private static final void transform_aroundBody0(XMLTransformer xMLTransformer, Reader reader, Writer writer, JoinPoint joinPoint) {
        Transformer transformer = xMLTransformer.templates.newTransformer();
        transformer.transform(new StreamSource(reader), new StreamResult(writer));
    }

    /*
     * WARNING - void declaration
     */
    private static final Object transform_aroundBody1$advice(XMLTransformer this_, Reader ajc_aroundClosure, Writer thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            XMLTransformer.transform_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        void var11_11 = result;
        XMLTransformer.transform_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }
}

