/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.text.NotifyingReconciler;

public class RubyReconciler
extends NotifyingReconciler {
    private Object fMutex;
    private boolean fIninitalProcessDone = false;
    private ResourceChangeListener fResourceChangeListener;
    private ITextEditor fTextEditor;

    public RubyReconciler(ITextEditor iTextEditor, IReconcilingStrategy iReconcilingStrategy, boolean bl) {
        super(iReconcilingStrategy, bl);
        this.fTextEditor = iTextEditor;
        this.fMutex = iTextEditor instanceof RubyEditor ? ((RubyEditor)iTextEditor).getReconcilerLock() : new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DirtyRegion dirtyRegion) {
        Object object = this.fMutex;
        synchronized (object) {
            super.process(dirtyRegion);
        }
    }

    public void install(ITextViewer iTextViewer) {
        super.install(iTextViewer);
        this.fResourceChangeListener = new ResourceChangeListener();
        IWorkspace iWorkspace = RubyCore.getWorkspace();
        iWorkspace.addResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener);
    }

    protected void forceReconciling() {
        if (!this.fIninitalProcessDone) {
            return;
        }
        super.forceReconciling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialProcess() {
        Object object = this.fMutex;
        synchronized (object) {
            super.initialProcess();
        }
        this.fIninitalProcessDone = true;
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        private IResource getResource() {
            if (RubyReconciler.this.fTextEditor == null) {
                return null;
            }
            IEditorInput iEditorInput = RubyReconciler.this.fTextEditor.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                return iFileEditorInput.getFile();
            }
            return null;
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IMarkerDelta[] iMarkerDeltaArray;
            IResourceDelta iResourceDelta;
            IResourceDelta iResourceDelta2 = iResourceChangeEvent.getDelta();
            IResource iResource = this.getResource();
            if (iResourceDelta2 != null && iResource != null && (iResourceDelta = iResourceDelta2.findMember(iResource.getFullPath())) != null && (iMarkerDeltaArray = iResourceDelta.getMarkerDeltas()).length > 0) {
                RubyReconciler.this.forceReconciling();
            }
        }
    }
}

