/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.actions;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.rubypeople.rdt.core.ICodeAssist;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.OpenActionUtil;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.ui.IWorkingCopyManager;

public class SelectionConverter {
    private static final IRubyElement[] EMPTY_RESULT = new IRubyElement[0];

    public static IRubyScript getInputAsRubyScript(RubyEditor rubyEditor) {
        IRubyElement iRubyElement = SelectionConverter.getInput(rubyEditor);
        if (iRubyElement instanceof IRubyScript) {
            return (IRubyScript)iRubyElement;
        }
        return null;
    }

    public static IRubyElement getInput(RubyEditor rubyEditor) {
        if (rubyEditor == null) {
            return null;
        }
        IEditorInput iEditorInput = rubyEditor.getEditorInput();
        IWorkingCopyManager iWorkingCopyManager = RubyPlugin.getDefault().getWorkingCopyManager();
        return iWorkingCopyManager.getWorkingCopy(iEditorInput);
    }

    public static boolean canOperateOn(RubyEditor rubyEditor) {
        if (rubyEditor == null) {
            return false;
        }
        return SelectionConverter.getInput(rubyEditor) != null;
    }

    public static IRubyElement codeResolve(RubyEditor rubyEditor, Shell shell, String string, String string2) throws RubyModelException {
        IRubyElement[] iRubyElementArray = SelectionConverter.codeResolve(rubyEditor);
        if (iRubyElementArray == null || iRubyElementArray.length == 0) {
            return null;
        }
        IRubyElement iRubyElement = iRubyElementArray[0];
        if (iRubyElementArray.length > 1) {
            iRubyElement = OpenActionUtil.selectRubyElement(iRubyElementArray, shell, string, string2);
        }
        return iRubyElement;
    }

    public static IRubyElement[] codeResolve(RubyEditor rubyEditor) throws RubyModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput(rubyEditor), (ITextSelection)rubyEditor.getSelectionProvider().getSelection());
    }

    public static IRubyElement[] codeResolve(IRubyElement iRubyElement, ITextSelection iTextSelection) throws RubyModelException {
        if (iRubyElement instanceof ICodeAssist) {
            IRubyElement[] iRubyElementArray;
            if (iRubyElement instanceof IRubyScript) {
                RubyModelUtil.reconcile((IRubyScript)iRubyElement);
            }
            if ((iRubyElementArray = ((ICodeAssist)iRubyElement).codeSelect(iTextSelection.getOffset(), iTextSelection.getLength())) != null && iRubyElementArray.length > 0) {
                return iRubyElementArray;
            }
        }
        return EMPTY_RESULT;
    }
}

