/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.jruby.ast.Node;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;
import org.rubypeople.rdt.internal.core.builder.IoUtils;
import org.rubypeople.rdt.internal.core.parser.IRdtWarnings;

public class RubyParser {
    private final RubyParserPool pool;
    private IRdtWarnings warnings;
    private static boolean isDebug;

    public RubyParser() {
        this(new NullRdtWarnings());
    }

    public RubyParser(IRdtWarnings iRdtWarnings) {
        this.warnings = iRdtWarnings;
        this.pool = RubyParserPool.getInstance();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node parse(IFile iFile, Reader reader) {
        DefaultRubyParser defaultRubyParser = null;
        RubyParserResult rubyParserResult = null;
        try {
            this.warnings.setFile(iFile);
            defaultRubyParser = this.getDefaultRubyParser();
            defaultRubyParser.setWarnings((IRubyWarnings)this.warnings);
            defaultRubyParser.init(new RubyParserConfiguration());
            LexerSource lexerSource = new LexerSource(iFile.getName(), reader);
            rubyParserResult = defaultRubyParser.parse(lexerSource);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.pool.returnParser(defaultRubyParser);
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.pool.returnParser(defaultRubyParser);
        return rubyParserResult.getAST();
    }

    protected DefaultRubyParser getDefaultRubyParser() {
        return this.pool.borrowParser();
    }

    public static void setDebugging(boolean bl) {
        isDebug = bl;
    }

    public static boolean isDebugging() {
        return isDebug;
    }

    public Node parse(IFile iFile) throws CoreException {
        Node node;
        InputStream inputStream = null;
        try {
            inputStream = iFile.getContents();
            node = this.parse(iFile, new InputStreamReader(inputStream));
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            IoUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IoUtils.closeQuietly(inputStream);
        return node;
    }

    static class NullRdtWarnings
    extends NullWarnings
    implements IRdtWarnings {
        NullRdtWarnings() {
        }

        public void setFile(IFile iFile) {
        }
    }
}

