/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyModelInfo;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyModel
extends Openable
implements IRubyModel {
    protected RubyModel() {
        super(null);
    }

    protected Object createElementInfo() {
        return new RubyModelInfo();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RubyModel)) {
            return false;
        }
        return super.equals(object);
    }

    public Object[] getNonRubyResources() throws RubyModelException {
        return ((RubyModelInfo)this.getElementInfo()).getNonRubyResources();
    }

    public IRubyProject findRubyProject(IProject iProject) {
        try {
            IRubyProject[] iRubyProjectArray = this.getRubyProjects();
            int n = 0;
            int n2 = iRubyProjectArray.length;
            while (n < n2) {
                IRubyProject iRubyProject = iRubyProjectArray[n];
                if (iProject.equals((Object)iRubyProject.getProject())) {
                    return iRubyProject;
                }
                ++n;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return null;
    }

    public int getElementType() {
        return 0;
    }

    public IPath getPath() {
        return Path.ROOT;
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IRubyProject[] getRubyProjects() throws RubyModelException {
        ArrayList arrayList = this.getChildrenOfType(1);
        IRubyProject[] iRubyProjectArray = new IRubyProject[arrayList.size()];
        arrayList.toArray(iRubyProjectArray);
        return iRubyProjectArray;
    }

    protected boolean buildStructure(OpenableElementInfo openableElementInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        int n2 = iProjectArray.length;
        while (n < n2) {
            IProject iProject = iProjectArray[n];
            if (RubyProject.hasRubyNature(iProject)) {
                openableElementInfo.addChild(this.getRubyProject((IResource)iProject));
            }
            ++n;
        }
        map.put(this, openableElementInfo);
        return true;
    }

    public IRubyProject getRubyProject(IResource iResource) {
        switch (iResource.getType()) {
            case 2: {
                return new RubyProject(((IFolder)iResource).getProject(), this);
            }
            case 1: {
                return new RubyProject(((IFile)iResource).getProject(), this);
            }
            case 4: {
                return new RubyProject((IProject)iResource, this);
            }
        }
        throw new IllegalArgumentException(Util.bind("element.invalidResourceForProject"));
    }

    public IRubyProject getRubyProject(String string) {
        return new RubyProject(ResourcesPlugin.getWorkspace().getRoot().getProject(string), this);
    }
}

