/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.resolver.ModuleEntry;
import fr.jayasoft.ivy.resolver.OrganisationEntry;
import fr.jayasoft.ivy.resolver.ResolvedResource;
import fr.jayasoft.ivy.resolver.RevisionEntry;
import fr.jayasoft.ivy.resolver.URLResolver;
import java.io.File;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class IBiblioResolver
extends URLResolver {
    public static final String DEFAULT_PATTERN = "[module]/[type]s/[artifact]-[revision].[ext]";
    public static final String DEFAULT_ROOT = "http://www.ibiblio.org/maven/";
    private String _root = null;
    private String _pattern = null;
    private boolean _usepoms = true;

    protected ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        if (this.isM2compatible() && this.isUsepoms()) {
            ModuleRevisionId mrid = dd.getDependencyRevisionId();
            mrid = this.convertM2IdForResourceSearch(mrid);
            ResolvedResource rres = this.findResourceUsingPatterns(mrid, this.getIvyPatterns(), DefaultArtifact.newPomArtifact(mrid, data.getDate()), this.getRMDParser(dd, data), data.getDate());
            return rres;
        }
        return null;
    }

    protected void logIvyNotFound(ModuleRevisionId mrid) {
        if (this.isM2compatible() && this.isUsepoms()) {
            Artifact artifact = DefaultArtifact.newPomArtifact(mrid, null);
            this.logMdNotFound(mrid, artifact);
        }
    }

    public void setM2compatible(boolean m2compatible) {
        super.setM2compatible(m2compatible);
        if (m2compatible) {
            this._root = "http://www.ibiblio.org/maven2/";
            this._pattern = "[organisation]/[module]/[revision]/[artifact]-[revision].[ext]";
            this.updateWholePattern();
        }
    }

    public void ensureConfigured(Ivy ivy) {
        if (ivy != null && (this._root == null || this._pattern == null)) {
            if (this._root == null) {
                String root = ivy.getVariable("ivy.ibiblio.default.artifact.root");
                if (root != null) {
                    this._root = root;
                } else {
                    ivy.configureRepositories(true);
                    this._root = ivy.getVariable("ivy.ibiblio.default.artifact.root");
                }
            }
            if (this._pattern == null) {
                String pattern = ivy.getVariable("ivy.ibiblio.default.artifact.pattern");
                if (pattern != null) {
                    this._pattern = pattern;
                } else {
                    ivy.configureRepositories(false);
                    this._pattern = ivy.getVariable("ivy.ibiblio.default.artifact.pattern");
                }
            }
            this.updateWholePattern();
        }
    }

    private String getWholePattern() {
        return this._root + this._pattern;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this._pattern = pattern;
        this.ensureConfigured(this.getIvy());
        this.updateWholePattern();
    }

    public String getRoot() {
        return this._root;
    }

    public void setRoot(String root) {
        if (root == null) {
            throw new NullPointerException("root must not be null");
        }
        this._root = !root.endsWith("/") ? root + "/" : root;
        this.ensureConfigured(this.getIvy());
        this.updateWholePattern();
    }

    private void updateWholePattern() {
        if (this.isM2compatible() && this.isUsepoms()) {
            this.setIvyPatterns(Collections.singletonList(this.getWholePattern()));
        }
        this.setArtifactPatterns(Collections.singletonList(this.getWholePattern()));
    }

    public void publish(Artifact artifact, File src) {
        throw new UnsupportedOperationException("publish not supported by IBiblioResolver");
    }

    public String[] listTokenValues(String token, Map otherTokenValues) {
        if ("organisation".equals(token)) {
            return new String[0];
        }
        if ("module".equals(token) && !this.isM2compatible()) {
            return new String[0];
        }
        this.ensureConfigured(this.getIvy());
        return super.listTokenValues(token, otherTokenValues);
    }

    public OrganisationEntry[] listOrganisations() {
        return new OrganisationEntry[0];
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        if (this.isM2compatible()) {
            this.ensureConfigured(this.getIvy());
            return super.listModules(org);
        }
        return new ModuleEntry[0];
    }

    public RevisionEntry[] listRevisions(ModuleEntry mod) {
        this.ensureConfigured(this.getIvy());
        return super.listRevisions(mod);
    }

    public String getTypeName() {
        return "ibiblio";
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        this.ensureConfigured(data.getIvy());
        return super.getDependency(dd, data);
    }

    protected ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        this.ensureConfigured(this.getIvy());
        return super.findArtifactRef(artifact, date);
    }

    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache, boolean useOrigin) {
        this.ensureConfigured(ivy);
        return super.download(artifacts, ivy, cache, useOrigin);
    }

    public boolean exists(Artifact artifact) {
        this.ensureConfigured(this.getIvy());
        return super.exists(artifact);
    }

    public List getArtifactPatterns() {
        this.ensureConfigured(this.getIvy());
        return super.getArtifactPatterns();
    }

    public boolean isUsepoms() {
        return this._usepoms;
    }

    public void setUsepoms(boolean usepoms) {
        this._usepoms = usepoms;
        this.updateWholePattern();
    }
}

