/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import [Ljava.lang.String;;
import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DefaultDependencyDescriptor;
import fr.jayasoft.ivy.DefaultModuleDescriptor;
import fr.jayasoft.ivy.DefaultPublishingDRResolver;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.report.ResolveReport;
import fr.jayasoft.ivy.url.CredentialsStore;
import fr.jayasoft.ivy.url.URLHandler;
import fr.jayasoft.ivy.url.URLHandlerDispatcher;
import fr.jayasoft.ivy.url.URLHandlerRegistry;
import fr.jayasoft.ivy.util.DefaultMessageImpl;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorWriter;
import fr.jayasoft.ivy.xml.XmlReportParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private static Options getOptions() {
        OptionBuilder.withArgName((String)"conffile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file for configuration");
        Option conf = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"cachedir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given directory for cache");
        Option cache = OptionBuilder.create((String)"cache");
        OptionBuilder.withArgName((String)"ivyfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as ivy file");
        Option ivyfile = OptionBuilder.create((String)"ivy");
        OptionBuilder.withArgName((String)"organisation module revision");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"use this instead of ivy file to do the rest of the work with this as a dependency.");
        Option dependency = OptionBuilder.create((String)"dependency");
        OptionBuilder.withArgName((String)"configurations");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"resolve given configurations");
        Option confs = OptionBuilder.create((String)"confs");
        OptionBuilder.withArgName((String)"retrievepattern");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given pattern as retrieve pattern");
        Option retrieve = OptionBuilder.create((String)"retrieve");
        OptionBuilder.withArgName((String)"cachepathfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"outputs a classpath consisting of all dependencies in cache (including transitive ones) of the given ivy file to the given cachepathfile");
        Option cachepath = OptionBuilder.create((String)"cachepath");
        OptionBuilder.withArgName((String)"revision");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given revision to publish the module");
        Option revision = OptionBuilder.create((String)"revision");
        OptionBuilder.withArgName((String)"status");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given status to publish the module");
        Option status = OptionBuilder.create((String)"status");
        OptionBuilder.withArgName((String)"ivypattern");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given pattern as resolved ivy file pattern");
        Option deliver = OptionBuilder.create((String)"deliverto");
        OptionBuilder.withArgName((String)"resolvername");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given resolver to publish to");
        Option publishResolver = OptionBuilder.create((String)"publish");
        OptionBuilder.withArgName((String)"artpattern");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given pattern to find artifacts to publish");
        Option publishPattern = OptionBuilder.create((String)"publishpattern");
        OptionBuilder.withArgName((String)"realm");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given realm for HTTP AUTH");
        Option realm = OptionBuilder.create((String)"realm");
        OptionBuilder.withArgName((String)"host");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given host for HTTP AUTH");
        Option host = OptionBuilder.create((String)"host");
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given username for HTTP AUTH");
        Option username = OptionBuilder.create((String)"username");
        OptionBuilder.withArgName((String)"passwd");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given password for HTTP AUTH");
        Option passwd = OptionBuilder.create((String)"passwd");
        OptionBuilder.withArgName((String)"main");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the main class to runtime process");
        Option main = OptionBuilder.create((String)"main");
        OptionBuilder.withArgName((String)"args");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"the arguments to runtime process");
        Option args = OptionBuilder.create((String)"args");
        Options options = new Options();
        options.addOption("debug", false, "set message level to debug");
        options.addOption("verbose", false, "set message level to verbose");
        options.addOption("warn", false, "set message level to warn");
        options.addOption("error", false, "set message level to error");
        options.addOption("novalidate", false, "do not validate ivy files against xsd");
        options.addOption("useOrigin", false, "use original artifact location with local resolvers instead of copying to the cache");
        options.addOption("sync", false, "in conjonction with -retrieve, does a synced retrieve");
        options.addOption("m2compatible", false, "use maven2 compatibility");
        options.addOption("?", false, "display this help");
        options.addOption(conf);
        options.addOption(confs);
        options.addOption(cache);
        options.addOption(ivyfile);
        options.addOption(dependency);
        options.addOption(retrieve);
        options.addOption(cachepath);
        options.addOption(revision);
        options.addOption(status);
        options.addOption(deliver);
        options.addOption(publishResolver);
        options.addOption(publishPattern);
        options.addOption(realm);
        options.addOption(host);
        options.addOption(username);
        options.addOption(passwd);
        options.addOption(main);
        options.addOption(args);
        return options;
    }

    public static void main(String[] args) throws Exception {
        Options options = Main.getOptions();
        GnuParser parser = new GnuParser();
        try {
            ModuleDescriptor md;
            File ivyfile;
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("?")) {
                Main.usage(options);
                return;
            }
            if (line.hasOption("debug")) {
                Message.init(new DefaultMessageImpl(4));
            } else if (line.hasOption("verbose")) {
                Message.init(new DefaultMessageImpl(3));
            } else if (line.hasOption("warn")) {
                Message.init(new DefaultMessageImpl(1));
            } else if (line.hasOption("error")) {
                Message.init(new DefaultMessageImpl(0));
            } else {
                Message.init(new DefaultMessageImpl(2));
            }
            boolean validate = !line.hasOption("novalidate");
            Ivy ivy = new Ivy();
            ivy.addAllVariables(System.getProperties());
            if (line.hasOption("m2compatible")) {
                ivy.setVariable("ivy.default.configuration.m2compatible", "true");
            }
            Main.configureURLHandler(line.getOptionValue("realm", null), line.getOptionValue("host", null), line.getOptionValue("username", null), line.getOptionValue("passwd", null));
            String confPath = line.getOptionValue("conf", "");
            if ("".equals(confPath)) {
                ivy.configureDefault();
            } else {
                File conffile = new File(confPath);
                if (!conffile.exists()) {
                    Main.error(options, "ivy configuration file not found: " + conffile);
                } else if (conffile.isDirectory()) {
                    Main.error(options, "ivy configuration file is not a file: " + conffile);
                }
                ivy.configure(conffile);
            }
            File cache = new File(ivy.substitute(line.getOptionValue("cache", ivy.getDefaultCache().getAbsolutePath())));
            if (!cache.exists()) {
                cache.mkdirs();
            } else if (!cache.isDirectory()) {
                Main.error(options, cache + " is not a directory");
            }
            String[] confs = line.hasOption("confs") ? line.getOptionValues("confs") : new String[]{"*"};
            if (line.hasOption("dependency")) {
                String[] dep = line.getOptionValues("dependency");
                if (dep.length != 3) {
                    Main.error(options, "dependency should be expressed with exactly 3 arguments: organisation module revision");
                }
                ivyfile = File.createTempFile("ivy", ".xml");
                ivyfile.deleteOnExit();
                md = DefaultModuleDescriptor.newDefaultInstance(ModuleRevisionId.newInstance(dep[0], dep[1] + "-caller", "working"));
                DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, ModuleRevisionId.newInstance(dep[0], dep[1], dep[2]), false, false, true);
                for (int i = 0; i < confs.length; ++i) {
                    dd.addDependencyConfiguration("default", confs[i]);
                }
                ((DefaultModuleDescriptor)md).addDependency(dd);
                XmlModuleDescriptorWriter.write(md, ivyfile);
                confs = new String[]{"default"};
            } else {
                ivyfile = new File(ivy.substitute(line.getOptionValue("ivy", "ivy.xml")));
                if (!ivyfile.exists()) {
                    Main.error(options, "ivy file not found: " + ivyfile);
                } else if (ivyfile.isDirectory()) {
                    Main.error(options, "ivy file is not a file: " + ivyfile);
                }
            }
            ResolveReport report = ivy.resolve(ivyfile.toURL(), null, confs, cache, null, validate, false, true, line.hasOption("useOrigin"), null);
            if (report.hasError()) {
                System.exit(1);
            }
            md = report.getModuleDescriptor();
            if (confs.length == 1 && "*".equals(confs[0])) {
                confs = md.getConfigurationsNames();
            }
            if (line.hasOption("retrieve")) {
                String retrievePattern = ivy.substitute(line.getOptionValue("retrieve"));
                if (retrievePattern.indexOf("[") == -1) {
                    retrievePattern = retrievePattern + "/lib/[conf]/[artifact].[ext]";
                }
                ivy.retrieve(md.getModuleRevisionId().getModuleId(), confs, cache, retrievePattern, null, null, line.hasOption("sync"), line.hasOption("useOrigin"));
            }
            if (line.hasOption("cachepath")) {
                Main.outputCachePath(ivy, cache, md, confs, line.getOptionValue("cachepath", "ivycachepath.txt"));
            }
            if (line.hasOption("revision")) {
                ivy.deliver(md.getResolvedModuleRevisionId(), ivy.substitute(line.getOptionValue("revision")), cache, ivy.substitute(line.getOptionValue("deliverto", "ivy-[revision].xml")), ivy.substitute(line.getOptionValue("status", "release")), null, new DefaultPublishingDRResolver(), validate);
                if (line.hasOption("publish")) {
                    ivy.publish(md.getResolvedModuleRevisionId(), ivy.substitute(line.getOptionValue("revision")), cache, ivy.substitute(line.getOptionValue("publishpattern", "distrib/[type]s/[artifact]-[revision].[ext]")), line.getOptionValue("publish"), ivy.substitute(line.getOptionValue("deliverto", "ivy-[revision].xml")), validate);
                }
            }
            if (line.hasOption("main")) {
                Main.invoke(ivy, cache, md, confs, line.getOptionValue("main"), line.getOptionValues("args"));
            }
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            Main.usage(options);
        }
    }

    private static void outputCachePath(Ivy ivy, File cache, ModuleDescriptor md, String[] confs, String outFile) {
        try {
            String pathSeparator = System.getProperty("path.separator");
            StringBuffer buf = new StringBuffer();
            XmlReportParser parser = new XmlReportParser();
            LinkedHashSet<Artifact> all = new LinkedHashSet<Artifact>();
            for (int i = 0; i < confs.length; ++i) {
                Artifact[] artifacts = parser.getArtifacts(md.getModuleRevisionId().getModuleId(), confs[i], cache);
                all.addAll(Arrays.asList(artifacts));
            }
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                buf.append(ivy.getArchiveFileInCache(cache, artifact).getCanonicalPath());
                if (!iter.hasNext()) continue;
                buf.append(pathSeparator);
            }
            PrintWriter writer = new PrintWriter(new FileOutputStream(outFile));
            writer.println(buf.toString());
            writer.close();
            System.out.println("cachepath output to " + outFile);
        }
        catch (Exception ex) {
            throw new RuntimeException("impossible to build ivy cache path: " + ex.getMessage(), ex);
        }
    }

    private static void invoke(Ivy ivy, File cache, ModuleDescriptor md, String[] confs, String mainclass, String[] args) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            XmlReportParser parser = new XmlReportParser();
            LinkedHashSet<Artifact> all = new LinkedHashSet<Artifact>();
            for (int i = 0; i < confs.length; ++i) {
                Artifact[] artifacts = parser.getArtifacts(md.getModuleRevisionId().getModuleId(), confs[i], cache);
                all.addAll(Arrays.asList(artifacts));
            }
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                urls.add(ivy.getArchiveFileInCache(cache, artifact).toURL());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("impossible to build ivy cache path: " + ex.getMessage(), ex);
        }
        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), Main.class.getClassLoader());
        try {
            Class<?> c = classLoader.loadClass(mainclass);
            Method mainMethod = c.getMethod("main", String;.class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class: " + mainclass, cnfe);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Could not find main method: " + mainclass, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find main method: " + mainclass, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No permissions to invoke main method: " + mainclass, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unexpected exception invoking main method: " + mainclass, e);
        }
    }

    private static void configureURLHandler(String realm, String host, String username, String passwd) {
        CredentialsStore.INSTANCE.addCredentials(realm, host, username, passwd);
        URLHandlerDispatcher dispatcher = new URLHandlerDispatcher();
        URLHandler httpHandler = URLHandlerRegistry.getHttp();
        dispatcher.setDownloader("http", httpHandler);
        dispatcher.setDownloader("https", httpHandler);
        URLHandlerRegistry.setDefault(dispatcher);
    }

    private static void error(Options options, String msg) {
        System.err.println(msg);
        Main.usage(options);
        System.exit(1);
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("ivy", options);
    }
}

