/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Visitor;

public class VolatileUsage
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    Map<String, FieldRecord> fieldInfo = new HashMap<String, FieldRecord>();
    Set<String> initializationWrites = new HashSet<String>();
    Set<String> otherWrites = new HashSet<String>();

    public VolatileUsage(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visit(Field obj) {
        super.visit(obj);
        int flags = obj.getAccessFlags();
        if ((flags & 0x40) == 0) {
            return;
        }
        if (this.getFieldSig().charAt(0) == '[') {
            FieldRecord f = new FieldRecord();
            f.className = this.getDottedClassName();
            f.name = this.getFieldName();
            f.signature = this.getFieldSig();
            f.isStatic = (flags & 8) != 0;
            this.fieldInfo.put(this.getDottedClassName() + "." + this.getFieldName(), f);
        }
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 179: {
                String name = (this.getClassConstantOperand() + "." + this.getNameConstantOperand()).replace('/', '.');
                if (this.getMethodName().equals("<clinit>")) {
                    this.initializationWrites.add(name);
                    break;
                }
                this.otherWrites.add(name);
                break;
            }
            case 181: {
                String name = (this.getClassConstantOperand() + "." + this.getNameConstantOperand()).replace('/', '.');
                if (this.getMethodName().equals("<init>")) {
                    this.initializationWrites.add(name);
                    break;
                }
                this.otherWrites.add(name);
                break;
            }
        }
    }

    public void report() {
        Iterator<Map.Entry<String, FieldRecord>> i$ = this.fieldInfo.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, FieldRecord> r = i$.next();
            String name = r.getKey();
            FieldRecord f = r.getValue();
            int priority = 3;
            if (this.initializationWrites.contains(name) && !this.otherWrites.contains(name)) {
                priority = 2;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "VO_VOLATILE_REFERENCE_TO_ARRAY", priority).addClass(f.className).addField(f.className, f.name, f.signature, f.isStatic));
        }
    }

    static class FieldRecord {
        String className;
        String name;
        String signature;
        boolean isStatic;

        FieldRecord() {
        }
    }
}

