/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.detect.DumbMethods;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class DoInsideDoPrivileged
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    boolean isDoPrivileged = false;

    public DoInsideDoPrivileged(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        try {
            this.isDoPrivileged = Repository.implementationOf((String)this.getClassName(), (String)"java/security/PrivilegedAction") || Repository.implementationOf((String)this.getClassName(), (String)"java/security/PrivilegedExceptionAction");
        }
        catch (ClassNotFoundException e) {
            this.isDoPrivileged = true;
        }
    }

    public void visit(Code obj) {
        if (this.isDoPrivileged && this.getMethodName().equals("run")) {
            return;
        }
        if (this.getMethod().isPrivate()) {
            return;
        }
        if (DumbMethods.isTestMethod(this.getMethod())) {
            return;
        }
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        try {
            String classOfConstructedClass;
            JavaClass constructedClass;
            String className;
            if (seen == 182 && this.getNameConstantOperand().equals("setAccessible") && ((className = this.getDottedClassConstantOperand()).equals("java.lang.reflect.Field") || className.equals("java.lang.reflect.Method"))) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DP_DO_INSIDE_DO_PRIVILEGED", 3).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (!(seen != 187 || !Repository.instanceOf((JavaClass)(constructedClass = Repository.lookupClass((String)(classOfConstructedClass = this.getClassConstantOperand()))), (String)"java/lang/ClassLoader") || this.getMethodName().equals("main") && this.getMethodSig().equals("([Ljava/lang/String;)V") && this.getMethod().isStatic())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED", 2).addClassAndMethod((PreorderVisitor)this).addClass(constructedClass).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

