/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.rule.Action;
import org.dom4j.rule.Mode;
import org.dom4j.rule.Rule;
import org.dom4j.rule.RuleManager;

public class Stylesheet {
    private RuleManager ruleManager = new RuleManager();
    private String modeName;

    public void addRule(Rule rule) {
        this.ruleManager.addRule(rule);
    }

    public void applyTemplates(Object input) throws Exception {
        Mode mode = this.getMode();
        if (mode != null) {
            if (input instanceof Element) {
                mode.applyTemplates((Element)input);
            } else if (input instanceof Document) {
                mode.applyTemplates((Document)input);
            } else if (input instanceof List) {
                List list = (List)input;
                int i = 0;
                int size = list.size();
                while (i < size) {
                    Object object = list.get(i);
                    if (object != input) {
                        if (object instanceof Element) {
                            mode.applyTemplates((Element)object);
                        } else if (object instanceof Document) {
                            mode.applyTemplates((Document)object);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void applyTemplates(Object input, XPath xpath) throws Exception {
        List list = xpath.selectNodes(input);
        int i = 0;
        int size = list.size();
        while (i < size) {
            Object object = list.get(i);
            if (object != input && object instanceof Node) {
                this.run((Node)object);
            }
            ++i;
        }
    }

    public void applyTemplates(Object input, org.jaxen.XPath xpath) throws Exception {
        List list = xpath.selectNodes(input);
        int i = 0;
        int size = list.size();
        while (i < size) {
            Object object = list.get(i);
            if (object != input && object instanceof Node) {
                this.run((Node)object);
            }
            ++i;
        }
    }

    public void clear() {
        this.ruleManager.clear();
    }

    protected Mode getMode() {
        return this.ruleManager.getMode(this.modeName);
    }

    public String getModeName() {
        return this.modeName;
    }

    public Action getValueOfAction() {
        return this.ruleManager.getValueOfAction();
    }

    public void removeRule(Rule rule) {
        this.ruleManager.addRule(rule);
    }

    public void run(Object input) throws Exception {
        if (input instanceof Node) {
            this.run((Node)input);
        } else if (input instanceof List) {
            this.run((List)input);
        }
    }

    public void run(List list) throws Exception {
        int i = 0;
        int size = list.size();
        while (i < size) {
            Object object = list.get(i);
            if (object instanceof Node) {
                this.run((Node)object);
            }
            ++i;
        }
    }

    public void run(Node node) throws Exception {
        Mode mode = this.getMode();
        if (mode != null) {
            mode.fireRule(node);
        }
    }

    public void setModeName(String modeName) {
        this.modeName = modeName;
    }

    public void setValueOfAction(Action valueOfAction) {
        this.ruleManager.setValueOfAction(valueOfAction);
    }
}

