/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.epic.perleditor.templates.ContextType;
import org.epic.perleditor.templates.TemplateContext;

public abstract class DocumentTemplateContext
extends TemplateContext {
    private final IDocument fDocument;
    private final int fCompletionOffset;
    private final int fCompletionLength;

    protected DocumentTemplateContext(ContextType type, IDocument document, int completionOffset, int completionLength) {
        super(type);
        this.fDocument = document;
        this.fCompletionOffset = completionOffset;
        this.fCompletionLength = completionLength;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public int getCompletionOffset() {
        return this.fCompletionOffset;
    }

    public int getCompletionLength() {
        return this.fCompletionLength;
    }

    public String getKey() {
        int offset = this.getStart();
        int length = this.getEnd() - offset;
        try {
            return this.fDocument.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public int getStart() {
        return this.fCompletionOffset;
    }

    public int getEnd() {
        return this.fCompletionOffset + this.fCompletionLength;
    }
}

