/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WidgetUtils {
    public static Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        return composite;
    }

    public static Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }

    public static Text createText(Composite parent, String initialValue) {
        Composite textComposite = WidgetUtils.createComposite(parent, 2);
        Text text = new Text(textComposite, 2052);
        text.setText(initialValue);
        text.setFont(parent.getFont());
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public static void addSpacer(Composite parent) {
        WidgetUtils.createLabel(parent, "");
    }

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        return label;
    }

    public static Composite createGroup(Composite parent, int fill) {
        Group composite = new Group(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(fill));
        composite.setLayout((Layout)new GridLayout());
        return composite;
    }
}

