/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.properties;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.epic.core.util.XMLUtilities;

public class IncludePathPropertyPage
extends PropertyPage {
    private List incPathList;
    private Composite fParent;
    private String filterPath = null;
    private Text newEntryText;
    private IProject project;
    static /* synthetic */ Class class$0;

    public void createControl(Composite parent) {
        this.noDefaultAndApplyButton();
        this.fParent = parent;
        super.createControl(parent);
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IResource resource = (IResource)iAdaptable.getAdapter((Class)clazz);
        this.project = resource.getProject();
    }

    protected Control createContents(Composite parent) {
        IResource resource;
        XMLUtilities xmlUtil;
        String[] listEntries;
        Composite entryTable = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        entryTable.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        entryTable.setLayout((Layout)layout);
        new Label(entryTable, 0);
        this.incPathList = new List(entryTable, 2048);
        data = new GridData(1808);
        this.incPathList.setLayoutData((Object)data);
        Composite buttonComposite = new Composite(entryTable, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 3;
        buttonComposite.setLayout((Layout)buttonLayout);
        data = new GridData(1810);
        buttonComposite.setLayoutData((Object)data);
        Button addButton = new Button(buttonComposite, 0x1000008);
        addButton.setText("Add to List");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (IncludePathPropertyPage.this.newEntryText.getText().trim().length() > 0) {
                    IncludePathPropertyPage.this.incPathList.add(IncludePathPropertyPage.this.newEntryText.getText(), IncludePathPropertyPage.this.incPathList.getItemCount());
                    IncludePathPropertyPage.this.newEntryText.setText("");
                }
            }
        });
        this.newEntryText = new Text(buttonComposite, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.newEntryText.setLayoutData((Object)data);
        Button browseButton = new Button(buttonComposite, 0x1000008);
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dirBrowser = new DirectoryDialog(IncludePathPropertyPage.this.fParent.getShell());
                dirBrowser.setFilterPath(IncludePathPropertyPage.this.filterPath);
                String dir = dirBrowser.open();
                if (dir != null) {
                    String projectDir = IncludePathPropertyPage.this.project.getLocation().toString();
                    if (dir.equals(projectDir)) {
                        dir = "${project_loc}";
                    } else if (dir.startsWith(projectDir)) {
                        dir = "${resource_loc:" + IncludePathPropertyPage.this.project.getFullPath().toString() + dir.substring(projectDir.length()) + "}";
                    }
                    IncludePathPropertyPage.this.newEntryText.setText(dir);
                    IncludePathPropertyPage.this.filterPath = dir.substring(0, dir.lastIndexOf(File.separator));
                }
            }
        });
        Button removeButton = new Button(buttonComposite, 0x1000008);
        removeButton.setText("Remove Selection");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IncludePathPropertyPage.this.incPathList.remove(IncludePathPropertyPage.this.incPathList.getSelectionIndex());
            }
        });
        data = new GridData();
        data.horizontalSpan = 2;
        removeButton.setLayoutData((Object)data);
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((listEntries = (xmlUtil = new XMLUtilities()).getIncludeEntries((resource = (IResource)iAdaptable.getAdapter((Class)clazz)).getProject())) != null) {
            this.incPathList.setItems(listEntries);
        }
        return entryTable;
    }

    public boolean performOk() {
        try {
            XMLUtilities xmlUtil = new XMLUtilities();
            xmlUtil.writeIncludeEntries(this.project, this.incPathList.getItems());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

