/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.cgi.server;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.StreamConsumer;
import org.epic.debug.PerlDebugPlugin;

public class CustomBrowser
implements IBrowser {
    public static final String CUSTOM_BROWSER_PATH_KEY = "custom_browser_path";
    String mPath;
    Process pr;

    public CustomBrowser(String fPath) {
        this.mPath = fPath;
    }

    public void close() {
        this.pr.destroy();
    }

    public boolean isCloseSupported() {
        return false;
    }

    public void displayURL(String url) throws Exception {
        String path = this.mPath;
        String[] command = this.prepareCommand(path, url);
        try {
            this.pr = Runtime.getRuntime().exec(command);
            StreamConsumer outConsumer = new StreamConsumer(this.pr.getInputStream());
            outConsumer.setName("Custom browser adapter output reader");
            outConsumer.start();
            StreamConsumer errConsumer = new StreamConsumer(this.pr.getErrorStream());
            errConsumer.setName("Custom browser adapter error reader");
            errConsumer.start();
        }
        catch (Exception e) {
            PerlDebugPlugin.getDefault().logError("CustomBrowser.errorLaunching " + path, e);
        }
    }

    public boolean isSetLocationSupported() {
        return false;
    }

    public boolean isSetSizeSupported() {
        return false;
    }

    public void setLocation(int x, int y) {
    }

    public void setSize(int width, int height) {
    }

    private String[] prepareCommand(String path, String url) {
        ArrayList<String> tokenList = new ArrayList<String>();
        StringTokenizer qTokenizer = new StringTokenizer(path.trim(), "\"", true);
        boolean withinQuotation = false;
        String quotedString = "";
        while (qTokenizer.hasMoreTokens()) {
            String curToken = qTokenizer.nextToken();
            if (curToken.equals("\"")) {
                if (withinQuotation) {
                    tokenList.add("\"" + quotedString + "\"");
                } else {
                    quotedString = "";
                }
                withinQuotation = !withinQuotation;
                continue;
            }
            if (withinQuotation) {
                quotedString = curToken;
                continue;
            }
            StringTokenizer parser = new StringTokenizer(curToken.trim());
            while (parser.hasMoreTokens()) {
                tokenList.add(parser.nextToken());
            }
        }
        boolean substituted = false;
        int i = 0;
        while (i < tokenList.size()) {
            String token = (String)tokenList.get(i);
            if ("%1".equals(token)) {
                tokenList.set(i, url);
                substituted = true;
            } else if ("\"%1\"".equals(token)) {
                tokenList.set(i, "\"" + url + "\"");
                substituted = true;
            }
            ++i;
        }
        if (!substituted) {
            tokenList.add(url);
        }
        String[] command = new String[tokenList.size()];
        tokenList.toArray(command);
        return command;
    }

    public static boolean isCustomBrowserID(String fID) {
        return fID.equals("org.eclipse.help.base.custombrowser");
    }
}

