/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: FileWriter.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef FILEWRITER_H
#define FILEWRITER_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <sstream>
#include <iostream>
#include <fstream>

using std::string;
using std::ofstream;

namespace Animorph {

class FileWriter : public ofstream
{
private:
  char *locale;

// Intionally declared as private because not implemented yet
private:
   FileWriter           (const FileWriter&);
   FileWriter& operator=(const FileWriter&);

public:
  FileWriter () : locale(NULL) {}

  /// destructor closes the file
  virtual ~FileWriter () {close ();}

  /*!
  * \param filename the file to open for writing
  * \return 0 if the file could be opened.
  */
  virtual int open (const string& filename);

  /// closes the currently opened file
  virtual void close ();

};

}

#endif // FILEWRITER_H
