/*

Copyright (C) 2000 - 2006 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_udp_h
#define __libnd_udp_h

#include <libnd.h>

#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#ifdef BSD_HOST
#include <netinet/ip_var.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* These are the implementations of LND_Protocol's callbacks: */
guchar    *libnd_udp_init_packet(LND_Packet *packet, guchar *data, guchar *data_end);
gboolean   libnd_udp_header_complete(const LND_Packet *packet, guint nesting);
gboolean   libnd_udp_datagram_complete(const LND_Packet *packet, guint nesting);
gboolean   libnd_udp_fix_packet(LND_Packet *packet);
gboolean   libnd_udp_adjust_len(LND_Packet *packet, int delta);

/* Generic accessor function for the protocol implementation: */
LND_Protocol *libnd_udp_get(void);

gboolean      libnd_udp_get_headers(const LND_Packet *packet,
				    struct ip **iphdr,
				    struct udphdr **udphdr);

guint         libnd_udp_get_payload_length(struct ip *iphdr, struct udphdr *udphdr);

guint16    libnd_udp_checksum(const LND_Packet *packet);
gboolean   libnd_udp_csum_correct(const LND_Packet *packet, guint16 *correct_sum);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
