/*

Copyright (C) 2000 - 2006 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __libnd_fddi_h
#define __libnd_fddi_h

#include <libnd.h>

#ifndef FDDI_K_ALEN
#define FDDI_K_ALEN 6
#endif

/* It seems every OS prefers this one in a different place and MacOS doesn't
 * provide it at all, so we don't even bother and just use our own :(
 */
struct fddi_header {
  guint8  fddi_fc;                    /* Frame Control (FC) value */
  guint8  fddi_dhost[FDDI_K_ALEN];    /* Destination host */
  guint8  fddi_shost[FDDI_K_ALEN];    /* Source host */
};

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* These are the implementations of LND_Protocol's callbacks: */
guchar      *libnd_fddi_init_packet(LND_Packet *packet, guchar *data, guchar *data_end);
gboolean     libnd_fddi_header_complete(const LND_Packet *packet, guint nesting);

/* Generic accessor function for the protocol implementation: */
LND_Protocol *libnd_fddi_get(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
